/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.jorisaerts.eclipse.rcp.environment.environment.EnvironmentVariables;
import com.kms.katalon.core.appium.constants.AppiumStringConstants;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class MobileDeviceInfo {
    protected static final String X_FLAG = "+x";
    protected static final String CHMOD_COMMAND = "chmod";
    protected static final String OS_RESOURCES_FOLDER = "os_resources";
    protected static final String CONFIGURATION_FOLDER_NAME = "configuration";
    protected String deviceId;

    public MobileDeviceInfo(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public abstract String getDisplayName();

    public abstract String getDeviceName();

    public abstract String getDeviceManufacturer();

    public abstract String getDeviceModel();

    public abstract String getDeviceOS();

    public abstract String getDeviceOSVersion();

    public abstract boolean isEmulator();

    protected static File getResourceFolder(String resourceFolderRelativePath) throws IOException {
        File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"com.kms.katalon.core.mobile"));
        if (bundleFile.isDirectory()) {
            return MobileDeviceInfo.getResourcesFolderFromBundle(resourceFolderRelativePath, bundleFile);
        }
        return MobileDeviceInfo.getResourcesFolderFromBuildResourcesFolder(resourceFolderRelativePath);
    }

    protected static File getResourcesFolderFromBuildResourcesFolder(String resourceFolderRelativePath) throws IOException {
        return new File(ClassPathResolver.getConfigurationFolder().getAbsolutePath() + File.separator + resourceFolderRelativePath);
    }

    protected static File getResourcesFolderFromBundle(String resourceFolderRelativePath, File bundleFile) {
        return new File(String.valueOf(bundleFile) + File.separator + OS_RESOURCES_FOLDER + File.separator + MobileDeviceInfo.getResourcesParentFolderFromOS() + File.separator + resourceFolderRelativePath);
    }

    private static String getResourcesParentFolderFromOS() {
        switch (Platform.getOS()) {
            case "win32": {
                return "win";
            }
            case "macosx": {
                return "macosx";
            }
            case "linux": {
                return "linux";
            }
        }
        return "";
    }

    public static void makeFileExecutable(File file) throws IOException, InterruptedException {
        ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])new String[]{CHMOD_COMMAND, X_FLAG, file.getAbsolutePath()});
    }

    protected static void makeFolderExecutable(File file, boolean recursive) throws IOException, InterruptedException {
        ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])new String[]{CHMOD_COMMAND, recursive ? "-R " : X_FLAG, file.getAbsolutePath()});
    }

    public Map<String, String> getDeviceSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.put("deviceId", this.getDeviceId());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_NAME, this.getDeviceName());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_MANUFACTURER, this.getDeviceManufacturer());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_MODEL, this.getDeviceModel());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_OS, this.getDeviceOS());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_OS_VERSON, this.getDeviceOSVersion());
        return systemProperties;
    }

    protected Map<String, String> getEnvironmentVariables() throws IOException, InterruptedException {
        return Collections.emptyMap();
    }

    public void updateRuntimeEnvironmentVariables() throws IOException, InterruptedException {
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        if (environmentVariables == null || environmentVariables.isEmpty()) {
            return;
        }
        environmentVariables.entrySet().forEach(e -> EnvironmentVariables.set((String)((String)e.getKey()), (String)((String)e.getValue()), (boolean)true));
    }
}

