/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.event.tracking;

import com.kms.katalon.ai.core.context.IAgentSessionContext;

public class ChatActionTrackingEvent {
    public static final String TOPIC = "STUDIOASSIST_TRACK_CHAT_ACTION";
    private final String action;
    private final String conversationId;
    private final String questionId;
    private final String chatMode;
    private final IAgentSessionContext agentSessionContext;

    private ChatActionTrackingEvent(Builder builder) {
        this.action = builder.action;
        this.conversationId = builder.conversationId;
        this.questionId = builder.questionId;
        this.chatMode = builder.chatMode;
        this.agentSessionContext = builder.agentSessionContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAction() {
        return this.action;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public String getChatMode() {
        return this.chatMode;
    }

    public IAgentSessionContext getAgentSessionContext() {
        return this.agentSessionContext;
    }

    public static class Builder {
        private String action;
        private String conversationId;
        private String questionId;
        private String chatMode;
        private IAgentSessionContext agentSessionContext;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        public Builder agentSessionContext(IAgentSessionContext agentSessionContext) {
            this.agentSessionContext = agentSessionContext;
            return this;
        }

        public ChatActionTrackingEvent build() {
            return new ChatActionTrackingEvent(this);
        }
    }
}

