/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.chat;

import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistConversation {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistConversation.class);
    private String conversationId = UUID.randomUUID().toString();
    private volatile ArrayBlockingQueue<StudioAssistChatItem> messages;

    public StudioAssistConversation(int queueCapacity, boolean fair) {
        this.messages = new ArrayBlockingQueue(queueCapacity, fair);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public ArrayBlockingQueue<StudioAssistChatItem> getMessages() {
        return this.messages;
    }

    public String reset() {
        this.conversationId = UUID.randomUUID().toString();
        this.messages.clear();
        return this.conversationId;
    }

    public void increaseQueueSize(int expandSize, boolean fair) {
        int currentQueueSize = this.messages.size();
        this.messages = new ArrayBlockingQueue<StudioAssistChatItem>(currentQueueSize + expandSize, fair, this.messages);
        this.logger.debug("The chat history queue capacity is full %s, expand the queue to %s".formatted(currentQueueSize, this.messages.size() + this.messages.remainingCapacity()));
    }

    public boolean addChatItemIntoHistory(StudioAssistChatItem chatItem) {
        return this.messages.add(chatItem);
    }

    public List<StudioAssistChatItem> getValidChatItems() {
        return this.messages.stream().filter(StudioAssistChatItem::isValidForConversationHistory).collect(Collectors.toList());
    }
}

