/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.llm;

import com.kms.katalon.ai.core.model.llm.InlineFileInput;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.TextInput;
import com.kms.katalon.ai.core.model.llm.UserInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CompositeUserMessage
extends LlmMessage {
    private String name;
    private List<UserInput> inputs = List.of();

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<UserInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<UserInput> inputs) {
        if (inputs == null) {
            this.inputs = List.of();
            return;
        }
        this.inputs = List.copyOf(inputs);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void that;
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeUserMessage)) {
            return false;
        }
        CompositeUserMessage compositeUserMessage = (CompositeUserMessage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.inputs, that.inputs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inputs);
    }

    public static class Builder {
        private final List<UserInput> inputs = new ArrayList<UserInput>();
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addInput(UserInput input) {
            this.inputs.add(Objects.requireNonNull(input, "UserInput cannot be null"));
            return this;
        }

        public Builder addTextInput(String text) {
            return this.addInput(TextInput.of(text));
        }

        public Builder addTextInput(TextInput input) {
            return this.addInput(input);
        }

        public Builder addInlineFileInput(InlineFileInput.Builder builder) {
            return this.addInlineFileInput(builder.build());
        }

        public Builder addInlineFileInput(InlineFileInput input) {
            return this.addInput(input);
        }

        public Builder addInlineImageInput(InlineImageInput.Builder builder) {
            return this.addInlineImageInput(builder.build());
        }

        public Builder addInlineImageInput(InlineImageInput input) {
            return this.addInput(input);
        }

        public CompositeUserMessage build() {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("CompositeUserMessage requires at least one input");
            }
            CompositeUserMessage message = new CompositeUserMessage();
            message.setName(this.name);
            message.setInputs(this.inputs);
            return message;
        }
    }
}

