/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.llm;

public enum ImageFormat {
    PNG("image/png"),
    JPEG("image/jpeg"),
    WEBP("image/webp"),
    GIF("image/gif"),
    HEIC("image/heic"),
    HEIF("image/heif");

    private final String mimeType;

    private ImageFormat(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static ImageFormat fromExtension(String extension) {
        return switch (extension.toLowerCase()) {
            case "png" -> PNG;
            case "jpg", "jpeg" -> JPEG;
            case "webp" -> WEBP;
            case "gif" -> GIF;
            case "heic" -> HEIC;
            case "heif" -> HEIF;
            default -> null;
        };
    }
}

