/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.retry;

import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.exception.McpClientUnauthorizedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistAttachmentValidationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiCostQuotaExceededException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiIncompatibleModelException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiProxyException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRateLimitReachedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistServiceUnreachableException;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.EventListener;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.event.ExecutionCompletedEvent;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistRetryPolicy.class);
    private static final int DEFAULT_MAX_RETRIES = 1;
    private static final Duration INITIAL_DELAY = Duration.ofSeconds(3L);
    private static final Duration MAX_DELAY = Duration.ofSeconds(10L);
    private static final Duration MAX_DURATION = Duration.ofSeconds(60L);
    private static final double JITTER_FACTOR = 0.5;

    public static <T> RetryPolicy<T> createAskModeRetryPolicy() {
        return StudioAssistRetryPolicy.createRetryPolicy(ChatMode.ASK.getName(), 1);
    }

    public static <T> RetryPolicy<T> createAgentModeRetryPolicy() {
        return StudioAssistRetryPolicy.createRetryPolicy(ChatMode.AGENT.getName(), 1);
    }

    public static <T> RetryPolicy<T> createRetryPolicy(String chatMode, int maxRetries) {
        return ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleIf(StudioAssistRetryPolicy::isRetryableException)).withMaxRetries(maxRetries).withBackoff(INITIAL_DELAY, MAX_DELAY).withMaxDuration(MAX_DURATION).withJitter(0.5).onRetry(StudioAssistRetryPolicy.createRetryListener(chatMode)).onFailedAttempt(StudioAssistRetryPolicy.createFailedAttemptListener(chatMode)).onRetriesExceeded(StudioAssistRetryPolicy.createRetriesExceededListener(chatMode)).onSuccess(StudioAssistRetryPolicy.createSuccessListener(chatMode))).build();
    }

    public static boolean isRetryableException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (StudioAssistRetryPolicy.isRetryableExceptionType(throwable)) {
            logger.debug("Exception is retryable: {}", (Object)throwable.getClass().getSimpleName());
            return true;
        }
        Throwable cause = throwable.getCause();
        if (cause != null && cause != throwable) {
            return StudioAssistRetryPolicy.isRetryableException(cause);
        }
        logger.debug("Exception is not retryable: {}", (Object)throwable.getClass().getSimpleName());
        return false;
    }

    private static boolean isRetryableExceptionType(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof NullPointerException || throwable instanceof IllegalArgumentException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiTimeoutException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiServerTimeoutException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiResourceExhaustedException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiRateLimitReachedException) {
            return true;
        }
        if (throwable instanceof StudioAssistServiceUnreachableException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiNoInternetException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiServerNoAnswerException) {
            return true;
        }
        if (throwable instanceof StudioAssistLlmApiAuthenticationException) {
            return false;
        }
        if (throwable instanceof McpClientUnauthorizedException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiServerContentViolatedException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiServerTokenExceededException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiCostQuotaExceededException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiIncompatibleModelException) {
            return false;
        }
        if (throwable instanceof StudioAssistLlmApiProxyException) {
            return false;
        }
        if (throwable instanceof StudioAssistConfigException) {
            return false;
        }
        if (throwable instanceof StudioAssistDisabledException) {
            return false;
        }
        if (throwable instanceof StudioAssistAttachmentValidationException) {
            return false;
        }
        return false;
    }

    private static String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long millis = duration.toMillis() % 1000L;
        return String.format("%d.%03ds", seconds, millis);
    }

    private static <T> EventListener<ExecutionAttemptedEvent<T>> createRetryListener(String mode) {
        return event -> {
            int attemptCount = event.getAttemptCount();
            Duration elapsedTime = event.getElapsedTime();
            logger.debug("[{}] Retry #{} after {}", new Object[]{mode, attemptCount, StudioAssistRetryPolicy.formatDuration(elapsedTime)});
        };
    }

    private static <T> EventListener<ExecutionAttemptedEvent<T>> createFailedAttemptListener(String mode) {
        return event -> {
            Throwable lastException = event.getLastException();
            int attemptCount = event.getAttemptCount() - 1;
            if (attemptCount == 0) {
                logger.debug("[{}] First execution failed. Exception: {} - Message: {}", new Object[]{mode, lastException.getClass().getSimpleName(), lastException != null ? lastException.getMessage() : "No message"});
            } else {
                logger.debug("[{}] Retry #{} failed. Exception: {} - Message: {}", new Object[]{mode, attemptCount, lastException.getClass().getSimpleName(), lastException != null ? lastException.getMessage() : "No message"});
            }
        };
    }

    private static <T> EventListener<ExecutionCompletedEvent<T>> createRetriesExceededListener(String mode) {
        return event -> {
            Throwable exception = event.getException();
            int attemptCount = event.getAttemptCount();
            logger.debug("[{}] All retry attempts exhausted after {} retries. Final exception: {} - message: {}", new Object[]{mode, attemptCount - 1, exception != null ? exception.getClass().getSimpleName() : "Unknown", exception != null ? exception.getMessage() : "No message"});
        };
    }

    private static <T> EventListener<ExecutionCompletedEvent<T>> createSuccessListener(String mode) {
        return event -> {
            int attemptCount = event.getAttemptCount() - 1;
            Throwable exception = event.getException();
            if (exception == null) {
                if (attemptCount == 0) {
                    logger.debug("[{}] Operation succeeded on first execution", (Object)mode);
                } else {
                    logger.debug("[{}] Operation succeeded after {} retries", (Object)mode, (Object)attemptCount);
                }
            } else {
                logger.debug("[{}] Operation completed with exception: {} - {}", new Object[]{mode, exception.getClass().getSimpleName(), exception.getMessage()});
            }
        };
    }
}

