/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.definition;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionFileLoader;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoader;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionWebLoader;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WebServiceDefinitionLoaderProvider {
    private WebServiceDefinitionLoaderProvider() {
    }

    public static WebServiceDefinitionLoader getLoader(String location) throws IOException {
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("Location must not be null or empty.");
        }
        if (WebServiceDefinitionLoaderProvider.isWebUrl(location)) {
            return WebServiceDefinitionLoaderProvider.getLoaderForWebLocation(location);
        }
        return WebServiceDefinitionLoaderProvider.getLoaderForFileLocation(location);
    }

    private static WebServiceDefinitionLoader getLoaderForFileLocation(String location) {
        return new WebServiceDefinitionFileLoader(location);
    }

    public static WebServiceDefinitionLoader getLoaderForWebLocation(String location) throws IOException {
        return WebServiceDefinitionLoaderProvider.getLoaderForWebLocation(location, Collections.emptyMap());
    }

    public static WebServiceDefinitionLoader getLoaderForWebLocation(String location, Map<String, String> httpHeaders) throws IOException {
        String projectLocation = WebServiceDefinitionLoaderProvider.getProjectLocation();
        if (StringUtils.isNotBlank((CharSequence)projectLocation)) {
            WebServiceSettingStore settingStore = WebServiceSettingStore.create(projectLocation);
            SSLCertificateOption certOption = settingStore.getSSLCertificateOption();
            SSLClientCertificateSettings clientCertSettings = settingStore.getClientCertificateSettings();
            ProxyInformation proxyInfo = WebServiceDefinitionLoaderProvider.getProxyInformation();
            return WebServiceDefinitionLoaderProvider.getLoaderForWebLocation(location, httpHeaders, proxyInfo, certOption, clientCertSettings);
        }
        return null;
    }

    private static ProxyInformation getProxyInformation() {
        ProxyInformation proxyInformation = null;
        try {
            proxyInformation = RunConfiguration.getProxyInformation();
        }
        catch (Exception exception) {}
        if (proxyInformation == null) {
            String proxyJson = System.getProperty("system.proxy");
            proxyInformation = (ProxyInformation)JsonUtil.fromJson((String)proxyJson, ProxyInformation.class);
        }
        return proxyInformation;
    }

    public static WebServiceDefinitionLoader getLoaderForWebLocation(String location, Map<String, String> httpHeaders, ProxyInformation proxyInfo, SSLCertificateOption certOption, SSLClientCertificateSettings clientCertSettings) {
        WebServiceDefinitionWebLoader loader = new WebServiceDefinitionWebLoader(location);
        loader.setHttpHeaders(httpHeaders);
        loader.setProxyInformation(proxyInfo);
        loader.setSslCertificateOption(certOption);
        loader.setSslClientCertSettings(clientCertSettings);
        return loader;
    }

    private static String getProjectLocation() {
        String projectLocation = null;
        try {
            projectLocation = RunConfiguration.getProjectDir();
        }
        catch (Exception exception) {}
        if (StringUtils.isBlank((CharSequence)projectLocation) || "null".equals(projectLocation)) {
            projectLocation = System.getProperty("project.location");
        }
        return projectLocation;
    }

    private static boolean isWebUrl(String url) {
        return url.startsWith("http") || url.startsWith("https");
    }
}

