/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.cache;

import com.kms.katalon.custom.improvement.cache.ParseKeywordCacheContent;
import com.kms.katalon.custom.improvement.model.CustomKeywordFile;
import com.kms.katalon.custom.improvement.parser.ReadCacheFileException;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;

public class ParseKeywordCacheFile {
    private static final String PROJECT_CACHE_FOLDER = ".cache";
    private static final String KEYWORD_CACHE_FOLDER = "Keywords";
    private CustomKeywordFile customKeywordFile;
    private File cacheSystemFile;
    private ParseKeywordCacheContent cacheContent;

    private ParseKeywordCacheFile(CustomKeywordFile customKeywordFile, File cacheSystemFile) {
        this.customKeywordFile = customKeywordFile;
        this.cacheSystemFile = cacheSystemFile;
    }

    public CustomKeywordFile getCustomKeywordFile() {
        return this.customKeywordFile;
    }

    public void loadContent() throws IOException {
        this.cacheContent = ParseKeywordCacheContent.fromFile(this.cacheSystemFile);
    }

    public ParseKeywordCacheContent getCacheContent() {
        return this.cacheContent;
    }

    public void writeContent(ParseKeywordCacheContent cacheContent) throws IOException {
        this.cacheContent = cacheContent;
        ParseKeywordCacheContent.toFile(cacheContent, this.cacheSystemFile);
    }

    public String getPath() {
        return this.cacheSystemFile.getAbsolutePath();
    }

    public static ParseKeywordCacheFile getOrCreate(CustomKeywordFile customKeywordFile) throws ReadCacheFileException {
        try {
            File cacheFolder = ParseKeywordCacheFile.getParseCustomKeywordCacheFolder(customKeywordFile.getProject());
            String relPath = customKeywordFile.getRelativePath();
            relPath = FilenameUtils.removeExtension((String)relPath);
            String cacheFileName = relPath.replaceAll("/", "__").replaceAll("[^a-zA-Z0-9-_\\.\\s]", "_");
            File cacheSystemFile = new File(cacheFolder, cacheFileName);
            ParseKeywordCacheFile cacheFile = null;
            if (!cacheSystemFile.exists()) {
                cacheSystemFile.createNewFile();
            }
            cacheFile = new ParseKeywordCacheFile(customKeywordFile, cacheSystemFile);
            cacheFile.loadContent();
            return cacheFile;
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Failed to read cache content for keyword file '{0}'", customKeywordFile.getRelativePath());
            throw new ReadCacheFileException(msg, e);
        }
    }

    public static File getParseCustomKeywordCacheFolder(ProjectEntity project) {
        File projectCacheFolder = ParseKeywordCacheFile.getProjectCacheFolder(project);
        File keywordCacheFolder = new File(projectCacheFolder, KEYWORD_CACHE_FOLDER);
        keywordCacheFolder.mkdir();
        return keywordCacheFolder;
    }

    private static File getProjectCacheFolder(ProjectEntity project) {
        File projectCacheFolder = new File(project.getFolderLocation(), PROJECT_CACHE_FOLDER);
        projectCacheFolder.mkdir();
        return projectCacheFolder;
    }
}

