/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.katalon.platform.api.execution.TestSuiteCollectionExecutionContext;
import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TestSuiteCollectionExecutionContextImpl
implements TestSuiteCollectionExecutionContext {
    private final Builder builder;

    private TestSuiteCollectionExecutionContextImpl(Builder builder) {
        this.builder = builder;
    }

    public String getId() {
        return this.builder.id;
    }

    public String getSourceId() {
        return this.builder.sourceId;
    }

    public long getStartTime() {
        return this.builder.startTime;
    }

    public long getEndTime() {
        return this.builder.endTime;
    }

    public String getReportLocation() {
        return new File(this.builder.projectLocation, this.builder.reportId).getAbsolutePath();
    }

    public String getReportFolderLocation() {
        String reportLocation = this.getReportLocation();
        return reportLocation.substring(0, reportLocation.lastIndexOf(File.separator));
    }

    public String getReportId() {
        return this.builder.reportId;
    }

    public List<TestSuiteExecutionContext> getTestSuiteResults() {
        return this.builder.testSuiteContexts;
    }

    public static class Builder {
        private String id;
        private String sourceId;
        private long startTime;
        private long endTime;
        private String reportId;
        private String projectLocation;
        private List<TestSuiteExecutionContext> testSuiteContexts = new ArrayList<TestSuiteExecutionContext>();

        private Builder(String id, String sourceId) {
            this.id = id;
            this.sourceId = sourceId;
        }

        public static Builder create(String id, String sourceId) {
            return new Builder(id, sourceId);
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withReportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public Builder withProjectLocation(String projectLocation) {
            this.projectLocation = projectLocation;
            return this;
        }

        public Builder withTestSuiteContexts(List<TestSuiteExecutionContext> testSuiteContexts) {
            this.testSuiteContexts = testSuiteContexts;
            return this;
        }

        public TestSuiteCollectionExecutionContextImpl build() {
            return new TestSuiteCollectionExecutionContextImpl(this);
        }
    }
}

