/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;

public abstract class AbstractLogFileWatcher
implements Runnable {
    protected static final String[] IGNORED_LIST = new String[]{"<log>", "</log>", "<?xml version=\"1.0\" encoding=\"windows-1252\" standalone=\"no\"?>", "<!DOCTYPE log SYSTEM \"logger.dtd\">"};
    protected static final String LINE_SEPERATOR = System.getProperty("line.separator");
    protected String header;
    protected int lineCount;
    protected int delay;
    protected BufferedReader reader;
    protected FileInputStream fis;
    protected InputStreamReader is;
    protected boolean stopSignal;

    public AbstractLogFileWatcher(File file, int delay) throws FileNotFoundException {
        this.delay = delay;
        this.fis = new FileInputStream(file);
        this.is = new InputStreamReader(this.fis);
        this.reader = new BufferedReader(this.is);
        this.lineCount = 0;
        this.header = "";
        this.stopSignal = false;
    }

    protected boolean isLineQualifier(String line) {
        return this.verifyLineNotInIgnoredListString(line);
    }

    protected boolean verifyLineNotInIgnoredListString(String line) {
        String[] stringArray = IGNORED_LIST;
        int n = IGNORED_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoredString = stringArray[n2];
            if (line.equals(ignoredString)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String prepareString(StringBuilder builder) {
        return builder.insert(0, this.header + IGNORED_LIST[0]).append(IGNORED_LIST[1]).toString();
    }

    public boolean isStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(boolean stopSignal) {
        this.stopSignal = stopSignal;
    }
}

