/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.platform;

import com.katalon.platform.api.controller.FolderController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.DynamicQueryingTestSuiteDescription;
import com.katalon.platform.api.model.FolderEntity;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.model.TestCaseEntity;
import com.katalon.platform.api.model.TestSuiteEntity;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.entity.util.EntityTagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DynamicBuiltInSearch
implements DynamicQueryingTestSuiteDescription {
    private static final List<String> DEFAULT_KEYWORDS = Arrays.asList("ids", "id", "name", "tag", "comment", "description", "tags");
    private static final String CONTENT_DELIMITER = ",";
    private FolderController folderController = (FolderController)ApplicationManager.getInstance().getControllerManager().getController(FolderController.class);

    public String getQueryingType() {
        return "Built-in Search";
    }

    public List<TestCaseEntity> query(ProjectEntity project, TestSuiteEntity testSuite, String fullSearchText) throws ResourceException {
        FolderEntity testCaseRoot = this.folderController.getFolder(project, "Test Cases");
        List<TestCaseEntity> allTestCases = this.getAllTestCases(project, testCaseRoot);
        return allTestCases.stream().filter(e -> this.isMatched((TestCaseEntity)e, fullSearchText)).collect(Collectors.toList());
    }

    private List<TestCaseEntity> getAllTestCases(ProjectEntity project, FolderEntity parentFolder) throws ResourceException {
        List childTestCases = this.folderController.getChildTestCases(project, parentFolder);
        for (FolderEntity childFolder : this.folderController.getChildFolders(project, parentFolder)) {
            childTestCases.addAll(this.getAllTestCases(project, childFolder));
        }
        return childTestCases;
    }

    public List<String> getDefaultKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(DEFAULT_KEYWORDS);
        return keywords;
    }

    public boolean isMatched(TestCaseEntity testCase, String filteringText) {
        String trimmedText = filteringText.trim();
        if (trimmedText.equals("")) {
            return false;
        }
        List<String> keywordList = this.getDefaultKeywords();
        Map<String, String> tagMap = this.parseSearchedString(keywordList.toArray(new String[0]), trimmedText);
        if (!tagMap.isEmpty()) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                String keyword = entry.getKey();
                if (!keywordList.contains(keyword) || this.compare(testCase, keyword, entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<String, String> parseSearchedString(String[] searchTags, String contentString) {
        if (searchTags != null) {
            HashMap<String, String> tagMap = new HashMap<String, String>();
            int i = 0;
            while (i < searchTags.length) {
                String tagRegex = searchTags[i] + "=\\([^\\)]+\\)";
                Matcher m = Pattern.compile(tagRegex).matcher(contentString);
                while (m.find()) {
                    String tagContent = contentString.substring(m.start() + searchTags[i].length() + 2, m.end() - 1);
                    tagMap.put(searchTags[i], tagContent);
                }
                ++i;
            }
            return tagMap;
        }
        return Collections.emptyMap();
    }

    public boolean compare(TestCaseEntity fileEntity, String keyword, String text) {
        if (fileEntity == null || keyword == null || text == null) {
            return false;
        }
        switch (keyword) {
            case "ids": {
                return this.textContainsEntityId(text.toLowerCase(), fileEntity);
            }
            case "id": {
                return StringUtils.equalsIgnoreCase((CharSequence)fileEntity.getId(), (CharSequence)text) || StringUtils.startsWithIgnoreCase((CharSequence)fileEntity.getId(), (CharSequence)(text + "/"));
            }
            case "name": {
                return StringUtils.containsIgnoreCase((CharSequence)fileEntity.getName(), (CharSequence)text);
            }
            case "tag": {
                return StringUtils.containsIgnoreCase((CharSequence)fileEntity.getTags(), (CharSequence)text);
            }
            case "description": {
                return StringUtils.containsIgnoreCase((CharSequence)fileEntity.getDescription(), (CharSequence)text);
            }
            case "tags": {
                return this.hasTags(fileEntity, text);
            }
        }
        return false;
    }

    private boolean textContainsEntityId(String text, TestCaseEntity testCase) {
        return Arrays.asList(text.split(CONTENT_DELIMITER)).stream().map(a -> a.trim()).filter(a -> StringUtils.equalsIgnoreCase((CharSequence)testCase.getId(), (CharSequence)a) || StringUtils.startsWithIgnoreCase((CharSequence)testCase.getId(), (CharSequence)(a + "/"))).findAny().isPresent();
    }

    private boolean hasTags(TestCaseEntity testCase, String searchTagValues) {
        if (StringUtils.isBlank((CharSequence)searchTagValues)) {
            return true;
        }
        String entityTagValues = testCase.getTags();
        if (StringUtils.isBlank((CharSequence)entityTagValues)) {
            return false;
        }
        Set searchTags = EntityTagUtil.parse((String)searchTagValues).stream().map(tag -> tag.toLowerCase()).collect(Collectors.toSet());
        Set entityTags = EntityTagUtil.parse((String)entityTagValues).stream().map(tag -> tag.toLowerCase()).collect(Collectors.toSet());
        return entityTags.containsAll(searchTags);
    }
}

