/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.internal.WindowsPlatformExecutionSettings;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class WindowsExecutionSettingStore
extends BundleSettingStore {
    private static final String WINDOWS_SETTINGS_FILE_NAME = "com.kms.katalon.execution.windows";
    public static final int EXECUTION_DEFAULT_ELEMENT_TIMEOUT = 60;
    public static final int EXECUTION_DEFAULT_ACTION_DELAY_IN_MILLIS = 0;
    private static final String CONF_PROPERTY_ELEMENT_TIMEOUT = "elementTimeout";
    private static final String CONF_PROPERTY_ACTION_DELAY_IN_MILLIS = "actionDelayInMillis";
    private static final String CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS = "actionDelayAffectedKeywords";
    public static final String[] DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS = new String[]{"click", "clickElementOffset", "doubleClick", "rightClick", "rightClickElementOffset", "mouseOver", "sendKeys", "setEncryptedText", "setText", "clearText", "selectOptionByLabel"};

    public static WindowsExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new WindowsExecutionSettingStore(projectEntity);
    }

    public WindowsExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), WINDOWS_SETTINGS_FILE_NAME, false);
    }

    public int getElementTimeout() throws IOException {
        return this.getInt(CONF_PROPERTY_ELEMENT_TIMEOUT, 60);
    }

    public void setElementTimeout(int elementTimeout) throws IOException {
        this.setProperty(CONF_PROPERTY_ELEMENT_TIMEOUT, elementTimeout);
    }

    public int safelyGetElementTimeout() {
        try {
            return this.getElementTimeout();
        }
        catch (Exception exception) {
            return 60;
        }
    }

    public int getActionDelayInMillis() throws IOException {
        return this.getInt(CONF_PROPERTY_ACTION_DELAY_IN_MILLIS, 0);
    }

    public void setActionDelayInMillis(int value) throws IOException {
        this.setProperty(CONF_PROPERTY_ACTION_DELAY_IN_MILLIS, value);
    }

    public void setActionDelayAffectedKeywords(List<String> keywords) throws IOException {
        String stringKeywords = keywords.stream().collect(Collectors.joining(","));
        this.setProperty(CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS, stringKeywords);
    }

    public List<String> getActionDelayAffectedKeywords() throws IOException {
        String stringKeywords = this.getString(CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS, null);
        if (stringKeywords == null) {
            return Arrays.asList(DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS);
        }
        return Arrays.stream(stringKeywords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public WindowsPlatformExecutionSettings getExecutionSettings() throws IOException {
        return new WindowsPlatformExecutionSettings.Builder().elementTimeoutInSeconds(this.getElementTimeout()).actionDelayInMillis(this.getActionDelayInMillis()).actionDelayAffectedKeywords(this.getActionDelayAffectedKeywords()).build();
    }
}

