/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.MarkedPlane;
import com.googlecode.javacv.Marker;
import com.googlecode.javacv.MarkerDetector;
import com.googlecode.javacv.ProjectiveDevice;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometricCalibrator {
    private Settings settings;
    MarkerDetector markerDetector;
    private MarkedPlane markedPlane;
    private ProjectiveDevice projectiveDevice;
    private LinkedList<Marker[]> allObjectMarkers = new LinkedList();
    private LinkedList<Marker[]> allImageMarkers = new LinkedList();
    private opencv_core.IplImage tempImage = null;
    private Marker[] lastDetectedMarkers = null;
    private opencv_core.CvMat warp = opencv_core.CvMat.create(3, 3);
    private opencv_core.CvMat prevWarp = opencv_core.CvMat.create(3, 3);
    private opencv_core.CvMat lastWarp = opencv_core.CvMat.create(3, 3);
    private opencv_core.CvMat warpSrcPts = opencv_core.CvMat.create(1, 4, 6, 2);
    private opencv_core.CvMat warpDstPts = opencv_core.CvMat.create(1, 4, 6, 2);
    private opencv_core.CvMat tempPts = opencv_core.CvMat.create(1, 4, 6, 2);

    public GeometricCalibrator(Settings settings, MarkerDetector.Settings detectorSettings, MarkedPlane markedPlane, ProjectiveDevice projectiveDevice) {
        this.settings = settings;
        this.markerDetector = new MarkerDetector(detectorSettings);
        this.markedPlane = markedPlane;
        this.projectiveDevice = projectiveDevice;
        opencv_core.cvSetIdentity(this.prevWarp);
        opencv_core.cvSetIdentity(this.lastWarp);
        if (markedPlane != null) {
            int w = markedPlane.getImage().width();
            int h2 = markedPlane.getImage().height();
            this.warpSrcPts.put(0.0, 0.0, w, 0.0, w, h2, 0.0, h2);
        }
    }

    public MarkerDetector getMarkerDetector() {
        return this.markerDetector;
    }

    public MarkedPlane getMarkedPlane() {
        return this.markedPlane;
    }

    public ProjectiveDevice getProjectiveDevice() {
        return this.projectiveDevice;
    }

    public LinkedList<Marker[]> getAllObjectMarkers() {
        return this.allObjectMarkers;
    }

    public void setAllObjectMarkers(LinkedList<Marker[]> allObjectMarkers) {
        this.allObjectMarkers = allObjectMarkers;
    }

    public LinkedList<Marker[]> getAllImageMarkers() {
        return this.allImageMarkers;
    }

    public void setAllImageMarkers(LinkedList<Marker[]> allImageMarkers) {
        this.allImageMarkers = allImageMarkers;
    }

    public Marker[] processImage(opencv_core.IplImage image) {
        boolean whiteMarkers;
        this.projectiveDevice.imageWidth = image.width();
        this.projectiveDevice.imageHeight = image.height();
        boolean bl = whiteMarkers = this.markedPlane.getForegroundColor().magnitude() > this.markedPlane.getBackgroundColor().magnitude();
        if (image.depth() > 8) {
            if (this.tempImage == null || this.tempImage.width() != image.width() || this.tempImage.height() != image.height()) {
                this.tempImage = opencv_core.IplImage.create(image.width(), image.height(), 8, 1, image.origin());
            }
            opencv_core.cvConvertScale(image, this.tempImage, 0.00390625, 0.0);
            this.lastDetectedMarkers = this.markerDetector.detect(this.tempImage, whiteMarkers);
        } else {
            this.lastDetectedMarkers = this.markerDetector.detect(image, whiteMarkers);
        }
        if ((double)this.lastDetectedMarkers.length < (double)this.markedPlane.getMarkers().length * this.settings.detectedBoardMin) {
            return null;
        }
        this.markedPlane.getTotalWarp(this.lastDetectedMarkers, this.warp);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.warpDstPts, this.warp);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.tempPts, this.prevWarp);
        double rmsePrev = opencv_core.cvNorm(this.warpDstPts, this.tempPts);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.tempPts, this.lastWarp);
        double rmseLast = opencv_core.cvNorm(this.warpDstPts, this.tempPts);
        opencv_core.cvCopy(this.warp, this.prevWarp);
        int imageSize = (image.width() + image.height()) / 2;
        if (rmsePrev < this.settings.patternSteadySize * (double)imageSize && rmseLast > this.settings.patternMovedSize * (double)imageSize) {
            return this.lastDetectedMarkers;
        }
        return null;
    }

    public void drawMarkers(opencv_core.IplImage image) {
        this.markerDetector.draw(image, this.lastDetectedMarkers);
    }

    public void addMarkers() {
        this.addMarkers(this.markedPlane.getMarkers(), this.lastDetectedMarkers);
    }

    public void addMarkers(Marker[] imageMarkers) {
        this.addMarkers(this.markedPlane.getMarkers(), imageMarkers);
    }

    public void addMarkers(Marker[] objectMarkers, Marker[] imageMarkers) {
        int maxLength = Math.min(objectMarkers.length, imageMarkers.length);
        Marker[] om = new Marker[maxLength];
        Marker[] im = new Marker[maxLength];
        int i2 = 0;
        block0: for (Marker m1 : objectMarkers) {
            for (Marker m22 : imageMarkers) {
                if (m1.id != m22.id) continue;
                om[i2] = m1;
                im[i2] = m22;
                ++i2;
                continue block0;
            }
        }
        if (i2 < maxLength) {
            om = Arrays.copyOf(om, i2);
            im = Arrays.copyOf(im, i2);
        }
        this.allObjectMarkers.add(om);
        this.allImageMarkers.add(im);
        opencv_core.cvCopy(this.prevWarp, this.lastWarp);
    }

    public int getImageCount() {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        return this.allObjectMarkers.size();
    }

    private opencv_core.CvMat[] getPoints(boolean useCenters) {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        Iterator i1 = this.allObjectMarkers.iterator();
        Iterator i2 = this.allImageMarkers.iterator();
        opencv_core.CvMat pointCounts = opencv_core.CvMat.create(1, this.allImageMarkers.size(), 4, 1);
        IntBuffer pointCountsBuf = pointCounts.getIntBuffer();
        int totalPointCount = 0;
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m22 = (Marker[])i2.next();
            assert (m1.length == m22.length);
            int n2 = m1.length * (useCenters ? 1 : 4);
            pointCountsBuf.put(n2);
            totalPointCount += n2;
        }
        i1 = this.allObjectMarkers.iterator();
        i2 = this.allImageMarkers.iterator();
        opencv_core.CvMat objectPoints = opencv_core.CvMat.create(1, totalPointCount, 5, 3);
        opencv_core.CvMat imagePoints = opencv_core.CvMat.create(1, totalPointCount, 5, 2);
        FloatBuffer objectPointsBuf = objectPoints.getFloatBuffer();
        FloatBuffer imagePointsBuf = imagePoints.getFloatBuffer();
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m23 = (Marker[])i2.next();
            for (int j2 = 0; j2 < m1.length; ++j2) {
                if (useCenters) {
                    double[] c1 = m1[j2].getCenter();
                    objectPointsBuf.put((float)c1[0]);
                    objectPointsBuf.put((float)c1[1]);
                    objectPointsBuf.put(0.0f);
                    double[] c2 = m23[j2].getCenter();
                    imagePointsBuf.put((float)c2[0]);
                    imagePointsBuf.put((float)c2[1]);
                    continue;
                }
                for (int k2 = 0; k2 < 4; ++k2) {
                    objectPointsBuf.put((float)m1[j2].corners[2 * k2]);
                    objectPointsBuf.put((float)m1[j2].corners[2 * k2 + 1]);
                    objectPointsBuf.put(0.0f);
                    imagePointsBuf.put((float)m23[j2].corners[2 * k2]);
                    imagePointsBuf.put((float)m23[j2].corners[2 * k2 + 1]);
                }
            }
        }
        return new opencv_core.CvMat[]{objectPoints, imagePoints, pointCounts};
    }

    public static double[] computeReprojectionError(opencv_core.CvMat object_points, opencv_core.CvMat image_points, opencv_core.CvMat point_counts, opencv_core.CvMat camera_matrix, opencv_core.CvMat dist_coeffs, opencv_core.CvMat rot_vects, opencv_core.CvMat trans_vects, opencv_core.CvMat per_view_errors) {
        opencv_core.CvMat image_points2 = opencv_core.CvMat.create(image_points.rows(), image_points.cols(), image_points.type());
        int image_count = rot_vects.rows();
        int points_so_far = 0;
        double total_err = 0.0;
        double max_err = 0.0;
        opencv_core.CvMat object_points_i = new opencv_core.CvMat();
        opencv_core.CvMat image_points_i = new opencv_core.CvMat();
        opencv_core.CvMat image_points2_i = new opencv_core.CvMat();
        IntBuffer point_counts_buf = point_counts.getIntBuffer();
        opencv_core.CvMat rot_vect = new opencv_core.CvMat();
        opencv_core.CvMat trans_vect = new opencv_core.CvMat();
        for (int i2 = 0; i2 < image_count; ++i2) {
            object_points_i.reset();
            image_points_i.reset();
            image_points2_i.reset();
            int point_count = point_counts_buf.get(i2);
            opencv_core.cvGetCols(object_points, object_points_i, points_so_far, points_so_far + point_count);
            opencv_core.cvGetCols(image_points, image_points_i, points_so_far, points_so_far + point_count);
            opencv_core.cvGetCols(image_points2, image_points2_i, points_so_far, points_so_far + point_count);
            points_so_far += point_count;
            opencv_core.cvGetRows(rot_vects, rot_vect, i2, i2 + 1, 1);
            opencv_core.cvGetRows(trans_vects, trans_vect, i2, i2 + 1, 1);
            opencv_calib3d.cvProjectPoints2(object_points_i, rot_vect, trans_vect, camera_matrix, dist_coeffs, image_points2_i);
            double err = opencv_core.cvNorm(image_points_i, image_points2_i);
            err *= err;
            if (per_view_errors != null) {
                per_view_errors.put(i2, Math.sqrt(err / (double)point_count));
            }
            total_err += err;
            for (int j2 = 0; j2 < point_count; ++j2) {
                double y2;
                double dy;
                double x1 = image_points_i.get(0, j2, 0);
                double y1 = image_points_i.get(0, j2, 1);
                double x2 = image_points2_i.get(0, j2, 0);
                double dx = x1 - x2;
                err = Math.sqrt(dx * dx + (dy = y1 - (y2 = image_points2_i.get(0, j2, 1))) * dy);
                if (!(err > max_err)) continue;
                max_err = err;
            }
        }
        return new double[]{Math.sqrt(total_err / (double)points_so_far), max_err};
    }

    public double[] calibrate(boolean useCenters) {
        int kn;
        ProjectiveDevice d2 = this.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d2.getSettings();
        if (d2.cameraMatrix == null) {
            d2.cameraMatrix = opencv_core.CvMat.create(3, 3);
            opencv_core.cvSetZero(d2.cameraMatrix);
            if ((dsettings.flags & 2) != 0) {
                d2.cameraMatrix.put(0, dsettings.initAspectRatio);
                d2.cameraMatrix.put(4, 1.0);
            }
        }
        int n2 = kn = dsettings.isFixK3() ? 4 : 5;
        if (dsettings.isRationalModel() && !dsettings.isFixK4() && !dsettings.isFixK4() && !dsettings.isFixK5()) {
            kn = 8;
        }
        if (d2.distortionCoeffs == null || d2.distortionCoeffs.cols() != kn) {
            d2.distortionCoeffs = opencv_core.CvMat.create(1, kn);
            opencv_core.cvSetZero(d2.distortionCoeffs);
        }
        opencv_core.CvMat rotVects = new opencv_core.CvMat();
        opencv_core.CvMat transVects = new opencv_core.CvMat();
        d2.extrParams = opencv_core.CvMat.create(this.allImageMarkers.size(), 6);
        opencv_core.cvGetCols(d2.extrParams, rotVects, 0, 3);
        opencv_core.cvGetCols(d2.extrParams, transVects, 3, 6);
        opencv_core.CvMat[] points = this.getPoints(useCenters);
        opencv_calib3d.cvCalibrateCamera2(points[0], points[1], points[2], opencv_core.cvSize(d2.imageWidth, d2.imageHeight), d2.cameraMatrix, d2.distortionCoeffs, rotVects, transVects, dsettings.flags);
        if (opencv_core.cvCheckArr(d2.cameraMatrix, 2, 0.0, 0.0) != 0 && opencv_core.cvCheckArr(d2.distortionCoeffs, 2, 0.0, 0.0) != 0 && opencv_core.cvCheckArr(d2.extrParams, 2, 0.0, 0.0) != 0) {
            d2.reprojErrs = opencv_core.CvMat.create(1, this.allImageMarkers.size());
            double[] err = GeometricCalibrator.computeReprojectionError(points[0], points[1], points[2], d2.cameraMatrix, d2.distortionCoeffs, rotVects, transVects, d2.reprojErrs);
            d2.avgReprojErr = err[0];
            d2.maxReprojErr = err[1];
            return err;
        }
        d2.cameraMatrix = null;
        d2.avgReprojErr = -1.0;
        d2.maxReprojErr = -1.0;
        return null;
    }

    public static double[] computeStereoError(opencv_core.CvMat imagePoints1, opencv_core.CvMat imagePoints2, opencv_core.CvMat M1, opencv_core.CvMat D1, opencv_core.CvMat M2, opencv_core.CvMat D2, opencv_core.CvMat F) {
        int N = imagePoints1.cols();
        opencv_core.CvMat L1 = opencv_core.CvMat.create(1, N, 5, 3);
        opencv_core.CvMat L2 = opencv_core.CvMat.create(1, N, 5, 3);
        opencv_imgproc.cvUndistortPoints(imagePoints1, imagePoints1, M1, D1, null, M1);
        opencv_imgproc.cvUndistortPoints(imagePoints2, imagePoints2, M2, D2, null, M2);
        opencv_calib3d.cvComputeCorrespondEpilines(imagePoints1, 1, F, L1);
        opencv_calib3d.cvComputeCorrespondEpilines(imagePoints2, 2, F, L2);
        double avgErr = 0.0;
        double maxErr = 0.0;
        opencv_core.CvMat p1 = imagePoints1;
        opencv_core.CvMat p2 = imagePoints2;
        for (int i2 = 0; i2 < N; ++i2) {
            double e1 = p1.get(0, i2, 0) * L2.get(0, i2, 0) + p1.get(0, i2, 1) * L2.get(0, i2, 1) + L2.get(0, i2, 2);
            double e2 = p2.get(0, i2, 0) * L1.get(0, i2, 0) + p2.get(0, i2, 1) * L1.get(0, i2, 1) + L1.get(0, i2, 2);
            double err = e1 * e1 + e2 * e2;
            avgErr += err;
            if (!((err = Math.sqrt(err)) > maxErr)) continue;
            maxErr = err;
        }
        return new double[]{Math.sqrt(avgErr / (double)N), maxErr};
    }

    public double[] calibrateStereo(boolean useCenters, GeometricCalibrator peer) {
        ProjectiveDevice d2 = this.projectiveDevice;
        ProjectiveDevice dp = peer.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d2.getSettings();
        ProjectiveDevice.CalibrationSettings dpsettings = (ProjectiveDevice.CalibrationSettings)dp.getSettings();
        opencv_core.CvMat[] points1 = this.getPoints(useCenters);
        opencv_core.CvMat[] points2 = peer.getPoints(useCenters);
        FloatBuffer objPts1 = points1[0].getFloatBuffer();
        FloatBuffer imgPts1 = points1[1].getFloatBuffer();
        IntBuffer imgCount1 = points1[2].getIntBuffer();
        FloatBuffer objPts2 = points2[0].getFloatBuffer();
        FloatBuffer imgPts2 = points2[1].getFloatBuffer();
        IntBuffer imgCount2 = points2[2].getIntBuffer();
        assert (imgCount1.capacity() == imgCount2.capacity());
        opencv_core.CvMat objectPointsMat = opencv_core.CvMat.create(1, Math.min(objPts1.capacity(), objPts2.capacity()), 5, 3);
        opencv_core.CvMat imagePoints1Mat = opencv_core.CvMat.create(1, Math.min(imgPts1.capacity(), imgPts2.capacity()), 5, 2);
        opencv_core.CvMat imagePoints2Mat = opencv_core.CvMat.create(1, Math.min(imgPts1.capacity(), imgPts2.capacity()), 5, 2);
        opencv_core.CvMat pointCountsMat = opencv_core.CvMat.create(1, imgCount1.capacity(), 4, 1);
        FloatBuffer objectPoints = objectPointsMat.getFloatBuffer();
        FloatBuffer imagePoints1 = imagePoints1Mat.getFloatBuffer();
        FloatBuffer imagePoints2 = imagePoints2Mat.getFloatBuffer();
        IntBuffer pointCounts = pointCountsMat.getIntBuffer();
        int end1 = 0;
        int end2 = 0;
        for (int i2 = 0; i2 < imgCount1.capacity(); ++i2) {
            int start1 = end1;
            int start2 = end2;
            end1 = start1 + imgCount1.get(i2);
            end2 = start2 + imgCount2.get(i2);
            int count = 0;
            block1: for (int j2 = start1; j2 < end1; ++j2) {
                float x1 = objPts1.get(j2 * 3);
                float y1 = objPts1.get(j2 * 3 + 1);
                float z1 = objPts1.get(j2 * 3 + 2);
                for (int k2 = start2; k2 < end2; ++k2) {
                    float x2 = objPts2.get(k2 * 3);
                    float y2 = objPts2.get(k2 * 3 + 1);
                    float z2 = objPts2.get(k2 * 3 + 2);
                    if (x1 != x2 || y1 != y2 || z1 != z2) continue;
                    objectPoints.put(x1);
                    objectPoints.put(y1);
                    objectPoints.put(z1);
                    imagePoints1.put(imgPts1.get(j2 * 2));
                    imagePoints1.put(imgPts1.get(j2 * 2 + 1));
                    imagePoints2.put(imgPts2.get(k2 * 2));
                    imagePoints2.put(imgPts2.get(k2 * 2 + 1));
                    ++count;
                    continue block1;
                }
            }
            if (count <= 0) continue;
            pointCounts.put(count);
        }
        objectPointsMat.cols(objectPoints.position() / 3);
        imagePoints1Mat.cols(imagePoints1.position() / 2);
        imagePoints2Mat.cols(imagePoints2.position() / 2);
        pointCountsMat.cols(pointCounts.position());
        d2.R = opencv_core.CvMat.create(3, 3);
        d2.R.put(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        d2.T = opencv_core.CvMat.create(3, 1);
        d2.T.put(0.0, 0.0, 0.0);
        d2.E = opencv_core.CvMat.create(3, 3);
        opencv_core.cvSetZero(d2.E);
        d2.F = opencv_core.CvMat.create(3, 3);
        opencv_core.cvSetZero(d2.F);
        dp.R = opencv_core.CvMat.create(3, 3);
        dp.T = opencv_core.CvMat.create(3, 1);
        dp.E = opencv_core.CvMat.create(3, 3);
        dp.F = opencv_core.CvMat.create(3, 3);
        opencv_calib3d.cvStereoCalibrate(objectPointsMat, imagePoints1Mat, imagePoints2Mat, pointCountsMat, d2.cameraMatrix, d2.distortionCoeffs, dp.cameraMatrix, dp.distortionCoeffs, opencv_core.cvSize(d2.imageWidth, d2.imageHeight), dp.R, dp.T, dp.E, dp.F, opencv_core.cvTermCriteria(3, 100, 1.0E-6), dpsettings.flags);
        d2.avgEpipolarErr = 0.0;
        d2.maxEpipolarErr = 0.0;
        double[] err = GeometricCalibrator.computeStereoError(imagePoints1Mat, imagePoints2Mat, d2.cameraMatrix, d2.distortionCoeffs, dp.cameraMatrix, dp.distortionCoeffs, dp.F);
        dp.avgEpipolarErr = err[0];
        dp.maxEpipolarErr = err[1];
        return err;
    }

    public static class Settings
    extends BaseChildSettings {
        double detectedBoardMin = 0.5;
        double patternSteadySize = 0.005;
        double patternMovedSize = 0.05;

        public double getDetectedBoardMin() {
            return this.detectedBoardMin;
        }

        public void setDetectedBoardMin(double detectedBoardMin) {
            this.detectedBoardMin = detectedBoardMin;
        }

        public double getPatternSteadySize() {
            return this.patternSteadySize;
        }

        public void setPatternSteadySize(double patternSteadySize) {
            this.patternSteadySize = patternSteadySize;
        }

        public double getPatternMovedSize() {
            return this.patternMovedSize;
        }

        public void setPatternMovedSize(double patternMovedSize) {
            this.patternMovedSize = patternMovedSize;
        }
    }
}

