/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.cpp.ARToolKitPlus;
import com.googlecode.javacv.cpp.opencv_core;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Marker
implements Cloneable {
    public int id;
    public double[] corners;
    public double confidence;
    private static opencv_core.IplImage[] imageCache = new opencv_core.IplImage[4096];
    private static final double[] src = new double[]{0.0, 0.0, 8.0, 0.0, 8.0, 8.0, 0.0, 8.0};
    private static ThreadLocal<opencv_core.CvMat> H3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> srcPts4x1 = opencv_core.CvMat.createThreadLocal(4, 1, 6, 2);
    private static ThreadLocal<opencv_core.CvMat> dstPts4x1 = opencv_core.CvMat.createThreadLocal(4, 1, 6, 2);

    public Marker(int id, double[] corners, double confidence) {
        this.id = id;
        this.corners = corners;
        this.confidence = confidence;
    }

    public Marker(int id, double ... corners) {
        this(id, corners, 1.0);
    }

    public Marker clone() {
        return new Marker(this.id, (double[])this.corners.clone(), this.confidence);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.id;
        hash = 37 * hash + (this.corners != null ? this.corners.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof Marker) {
            Marker m3 = (Marker)o2;
            return m3.id == this.id && Arrays.equals(m3.corners, this.corners);
        }
        return false;
    }

    public double[] getCenter() {
        double x = 0.0;
        double y = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            x += this.corners[2 * i2];
            y += this.corners[2 * i2 + 1];
        }
        return new double[]{x /= 4.0, y /= 4.0};
    }

    public opencv_core.IplImage getImage() {
        return Marker.getImage(this.id);
    }

    public static opencv_core.IplImage getImage(int id) {
        if (imageCache[id] == null) {
            Marker.imageCache[id] = opencv_core.IplImage.create(8, 8, 8, 1);
            ARToolKitPlus.createImagePatternBCH(id, imageCache[id].getByteBuffer());
        }
        return imageCache[id];
    }

    public void draw(opencv_core.IplImage image) {
        this.draw(image, opencv_core.CvScalar.BLACK, 1.0, null);
    }

    public void draw(opencv_core.IplImage image, opencv_core.CvScalar color, double scale, opencv_core.CvMat prewarp) {
        this.draw(image, color, scale, scale, prewarp);
    }

    public void draw(opencv_core.IplImage image, opencv_core.CvScalar color, double scaleX, double scaleY, opencv_core.CvMat prewarp) {
        opencv_core.CvMat H = H3x3.get();
        JavaCV.getPerspectiveTransform(src, this.corners, H);
        if (prewarp != null) {
            opencv_core.cvGEMM(prewarp, H, 1.0, null, 0.0, H, 0);
        }
        opencv_core.IplImage marker = this.getImage();
        ByteBuffer mbuf = marker.getByteBuffer();
        opencv_core.CvMat srcPts = srcPts4x1.get();
        opencv_core.CvMat dstPts = dstPts4x1.get();
        opencv_core.CvPoint tempPts = new opencv_core.CvPoint(4);
        int h2 = marker.height();
        int w = marker.width();
        for (int y = 0; y < h2; ++y) {
            for (int x = 0; x < w; ++x) {
                int i2;
                if (mbuf.get(y * w + x) != 0) continue;
                srcPts.put(new double[]{x, y, x + 1, y, x + 1, y + 1, x, y + 1});
                opencv_core.cvPerspectiveTransform(srcPts, dstPts, H);
                double centerx = 0.0;
                double centery = 0.0;
                for (i2 = 0; i2 < 4; ++i2) {
                    centerx += dstPts.get(i2 * 2);
                    centery += dstPts.get(i2 * 2 + 1);
                }
                centerx /= 4.0;
                centery /= 4.0;
                for (i2 = 0; i2 < 4; ++i2) {
                    double a2 = dstPts.get(i2 * 2);
                    double b2 = dstPts.get(i2 * 2 + 1);
                    double dx = centerx - a2;
                    double dy = centery - b2;
                    dx = dx < 0.0 ? -1.0 : 0.0;
                    dy = dy < 0.0 ? -1.0 : 0.0;
                    tempPts.position(i2).x((int)Math.round((a2 * scaleX + dx) * 65536.0));
                    tempPts.position(i2).y((int)Math.round((b2 * scaleY + dy) * 65536.0));
                }
                opencv_core.cvFillConvexPoly((opencv_core.CvArr)image, tempPts.position(0), 4, color, 8, 16);
            }
        }
    }

    public static Marker[][] createArray(ArraySettings settings) {
        return Marker.createArray(settings, 0.0, 0.0);
    }

    public static Marker[][] createArray(ArraySettings settings, double marginx, double marginy) {
        Marker[] markers = new Marker[settings.rows * settings.columns];
        int id = 0;
        for (int y = 0; y < settings.rows; ++y) {
            for (int x = 0; x < settings.columns; ++x) {
                double sx = settings.sizeX / 2.0;
                double sy = settings.sizeY / 2.0;
                double cx = (double)x * settings.spacingX + sx + marginx;
                double cy = (double)y * settings.spacingY + sy + marginy;
                markers[id] = new Marker(id, new double[]{cx - sx, cy - sy, cx + sx, cy - sy, cx + sx, cy + sy, cx - sx, cy + sy}, 1.0);
                ++id;
            }
        }
        if (!settings.checkered) {
            return new Marker[][]{markers};
        }
        Marker[] markers1 = new Marker[markers.length / 2];
        Marker[] markers2 = new Marker[markers.length / 2];
        for (int i2 = 0; i2 < markers.length; ++i2) {
            int y;
            int x = i2 % settings.columns;
            if (x % 2 == 0 ^ (y = i2 / settings.columns) % 2 == 0) {
                markers2[i2 / 2] = markers[i2];
                continue;
            }
            markers1[i2 / 2] = markers[i2];
        }
        return new Marker[][]{markers2, markers1};
    }

    public static Marker[][] createArray(int rows, int columns, double sizeX, double sizeY, double spacingX, double spacingY, boolean checkered, double marginx, double marginy) {
        ArraySettings s2 = new ArraySettings();
        s2.rows = rows;
        s2.columns = columns;
        s2.sizeX = sizeX;
        s2.sizeY = sizeY;
        s2.spacingX = spacingX;
        s2.spacingY = spacingY;
        s2.checkered = checkered;
        return Marker.createArray(s2, marginx, marginy);
    }

    public static void applyWarp(Marker[] markers, opencv_core.CvMat warp) {
        opencv_core.CvMat pts = srcPts4x1.get();
        for (Marker m3 : markers) {
            opencv_core.cvPerspectiveTransform(pts.put(m3.corners), pts, warp);
            pts.get(m3.corners);
        }
    }

    public String toString() {
        String s2 = "[" + this.id + ": " + "(" + this.corners[0] + ", " + this.corners[1] + ") " + "(" + this.corners[2] + ", " + this.corners[3] + ") " + "(" + this.corners[4] + ", " + this.corners[5] + ") " + "(" + this.corners[6] + ", " + this.corners[7] + ")]";
        return s2;
    }

    public static class ArraySettings
    extends BaseChildSettings {
        int rows = 8;
        int columns = 12;
        double sizeX = 200.0;
        double sizeY = 200.0;
        double spacingX = 300.0;
        double spacingY = 300.0;
        boolean checkered = true;

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
            this.firePropertyChange("rows", this.rows, this.rows);
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
            this.firePropertyChange("columns", this.columns, this.columns);
        }

        public double getSizeX() {
            return this.sizeX;
        }

        public void setSizeX(double sizeX) {
            this.sizeX = sizeX;
            this.firePropertyChange("sizeX", this.sizeX, this.sizeX);
        }

        public double getSizeY() {
            return this.sizeY;
        }

        public void setSizeY(double sizeY) {
            this.sizeY = sizeY;
            this.firePropertyChange("sizeY", this.sizeY, this.sizeY);
        }

        public double getSpacingX() {
            return this.spacingX;
        }

        public void setSpacingX(double spacingX) {
            this.spacingX = spacingX;
            this.firePropertyChange("spacingX", this.spacingX, this.spacingX);
        }

        public double getSpacingY() {
            return this.spacingY;
        }

        public void setSpacingY(double spacingY) {
            this.spacingY = spacingY;
            this.firePropertyChange("spacingY", this.spacingY, this.spacingY);
        }

        public boolean isCheckered() {
            return this.checkered;
        }

        public void setCheckered(boolean checkered) {
            this.checkered = checkered;
            this.firePropertyChange("checkered", this.checkered, this.checkered);
        }
    }
}

