/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Graphics;
import javax.swing.UIManager;

final class WindowsUtils {
    private WindowsUtils() {
    }

    public static void drawRoundedDashedRect(Graphics g2, int x, int y, int width, int height) {
        for (int vx = x + 1; vx < x + width; vx += 2) {
            g2.fillRect(vx, y, 1, 1);
            g2.fillRect(vx, y + height - 1, 1, 1);
        }
        int offset = (width + 1) % 2;
        for (int vy = y + 1; vy < y + height - offset; vy += 2) {
            g2.fillRect(x, vy, 1, 1);
            g2.fillRect(x + width - 1, vy + offset, 1, 1);
        }
    }

    static void drawFlush3DBorder(Graphics g2, int x, int y, int w, int h2) {
        g2.translate(x, y);
        g2.setColor(UIManager.getColor("controlLtHighlight"));
        g2.drawLine(0, 0, w - 2, 0);
        g2.drawLine(0, 0, 0, h2 - 2);
        g2.setColor(UIManager.getColor("controlShadow"));
        g2.drawLine(w - 1, 0, w - 1, h2 - 1);
        g2.drawLine(0, h2 - 1, w - 1, h2 - 1);
        g2.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g2, int x, int y, int w, int h2) {
        g2.translate(x, y);
        g2.setColor(UIManager.getColor("controlShadow"));
        g2.drawLine(0, 0, w - 2, 0);
        g2.drawLine(0, 0, 0, h2 - 2);
        g2.setColor(UIManager.getColor("controlLtHighlight"));
        g2.drawLine(w - 1, 0, w - 1, h2 - 1);
        g2.drawLine(0, h2 - 1, w - 1, h2 - 1);
        g2.translate(-x, -y);
    }
}

