/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.ui.SliderComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.QualityControl;

public class QualityAdapter
implements QualityControl,
ActionListener {
    protected float preferredValue;
    protected float minValue;
    protected float maxValue;
    protected float value;
    protected boolean settable;
    protected boolean isTSsupported;
    protected SliderComp sliderComp = null;
    private float scale = 100.0f;

    public QualityAdapter(float preferred, float min2, float max, boolean settable) {
        this(preferred, min2, max, false, settable);
    }

    public QualityAdapter(float preferred, float min2, float max, boolean isTSsupported, boolean settable) {
        this.preferredValue = preferred;
        this.minValue = min2;
        this.maxValue = max;
        this.value = preferred;
        this.settable = settable;
        this.isTSsupported = isTSsupported;
    }

    public float getQuality() {
        return this.value;
    }

    public float setQuality(float newValue) {
        if (newValue < this.minValue) {
            newValue = this.minValue;
        } else if (newValue > this.maxValue) {
            newValue = this.maxValue;
        }
        this.value = newValue;
        if (this.sliderComp != null) {
            this.sliderComp.setValue(this.value * this.scale);
        }
        if (this.settable) {
            return this.value;
        }
        return -1.0f;
    }

    public float getPreferredQuality() {
        return this.preferredValue;
    }

    public boolean isTemporalSpatialTradeoffSupported() {
        return this.isTSsupported;
    }

    protected String getName() {
        return "Quality";
    }

    public Component getControlComponent() {
        if (this.sliderComp == null) {
            this.sliderComp = new SliderComp(this.getName(), this.minValue * this.scale, this.maxValue * this.scale, this.value * this.scale);
            this.sliderComp.setActionListener(this);
        }
        return this.sliderComp;
    }

    public void actionPerformed(ActionEvent ae) {
        float newValue = this.sliderComp.getFloatValue() / this.scale;
        this.setQuality(newValue);
    }
}

