/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.Serializable;
import java.net.InetAddress;

public class SessionAddress
implements Serializable {
    private InetAddress m_dataAddress;
    private InetAddress m_controlAddress;
    private int m_dataPort;
    private int m_controlPort;
    private int ttl;
    public static final int ANY_PORT = -1;

    public SessionAddress(InetAddress dataAddress, int dataPort) {
        this.m_dataAddress = dataAddress;
        this.m_controlAddress = dataAddress;
        this.m_dataPort = dataPort;
        this.m_controlPort = dataPort + 1;
    }

    public SessionAddress(InetAddress dataAddress, int dataPort, int timeToLive) {
        this.m_dataAddress = dataAddress;
        this.m_controlAddress = dataAddress;
        this.m_dataPort = dataPort;
        this.m_controlPort = dataPort + 1;
        this.ttl = timeToLive;
    }

    public SessionAddress(InetAddress dataAddress, int dataPort, InetAddress controlAddress, int controlPort) {
        this.m_dataAddress = dataAddress;
        this.m_controlAddress = controlAddress;
        this.m_dataPort = dataPort;
        this.m_controlPort = controlPort;
    }

    public SessionAddress() {
        this(null, -1, null, -1);
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public InetAddress getDataAddress() {
        return this.m_dataAddress;
    }

    public void setDataHostAddress(InetAddress dataAddress) {
        this.m_dataAddress = dataAddress;
    }

    public void setDataPort(int dataPort) {
        this.m_dataPort = dataPort;
    }

    public String getDataHostAddress() {
        return this.m_dataAddress.getHostAddress();
    }

    public int getDataPort() {
        return this.m_dataPort;
    }

    public InetAddress getControlAddress() {
        return this.m_controlAddress;
    }

    public void setControlHostAddress(InetAddress controlAddress) {
        this.m_controlAddress = controlAddress;
    }

    public void setControlPort(int controlPort) {
        this.m_controlPort = controlPort;
    }

    public String getControlHostAddress() {
        return this.m_controlAddress.getHostAddress();
    }

    public int getControlPort() {
        return this.m_controlPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SessionAddress) {
            SessionAddress otheraddr = (SessionAddress)obj;
            InetAddress otherdest = otheraddr.getDataAddress();
            InetAddress othercontl = otheraddr.getControlAddress();
            int dport = otheraddr.getDataPort();
            int cport = otheraddr.getControlPort();
            if (otherdest.equals(this.m_dataAddress) && othercontl.equals(this.m_controlAddress) && dport == this.m_dataPort && cport == this.m_controlPort) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        String s2 = "DataAddress: ";
        s2 = this.m_dataAddress != null ? s2 + this.m_dataAddress.toString() : s2 + "null";
        s2 = s2 + "\nControlAddress: ";
        s2 = this.m_controlAddress != null ? s2 + this.m_controlAddress.toString() : s2 + "null";
        s2 = s2 + "\nDataPort: " + this.m_dataPort + "\nControlPort: " + this.m_controlPort;
        return s2;
    }
}

