/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import java.awt.Rectangle;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;

public class Relative {
    public static RelativeScreenRegionBuilder to(ScreenRegion screenRegion) {
        return new RelativeScreenRegionBuilder(screenRegion);
    }

    public static RelativeScreenLocationBuilder to(ScreenLocation screenLocation) {
        return new RelativeScreenLocationBuilder(screenLocation);
    }

    public static class RelativeScreenLocationBuilder {
        private ScreenLocation screenLocation;

        public RelativeScreenLocationBuilder(ScreenLocation screenLocation) {
            this.screenLocation = screenLocation;
        }

        public ScreenLocation getScreenLocation() {
            return this.screenLocation;
        }

        public RelativeScreenLocationBuilder above(int amount) {
            return new RelativeScreenLocationBuilder(this.screenLocation.getRelativeScreenLocation(0, -amount));
        }

        public RelativeScreenLocationBuilder below(int amount) {
            return new RelativeScreenLocationBuilder(this.screenLocation.getRelativeScreenLocation(0, amount));
        }

        public RelativeScreenLocationBuilder left(int amount) {
            return new RelativeScreenLocationBuilder(this.screenLocation.getRelativeScreenLocation(-amount, 0));
        }

        public RelativeScreenLocationBuilder right(int amount) {
            return new RelativeScreenLocationBuilder(this.screenLocation.getRelativeScreenLocation(amount, 0));
        }
    }

    public static class RelativeScreenRegionBuilder {
        private ScreenRegion screenRegion;

        public RelativeScreenRegionBuilder(ScreenRegion screenRegion) {
            this.screenRegion = screenRegion;
        }

        public RelativeScreenRegionBuilder right(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(this.screenRegion.getBounds().width, 0, amount, this.screenRegion.getBounds().height));
        }

        public RelativeScreenRegionBuilder left(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(-amount, 0, amount, this.screenRegion.getBounds().height));
        }

        public RelativeScreenRegionBuilder above(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(0, -amount, this.screenRegion.getBounds().width, amount));
        }

        public RelativeScreenRegionBuilder below(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(0, this.screenRegion.getBounds().height, this.screenRegion.getBounds().width, amount));
        }

        public RelativeScreenRegionBuilder taller(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(0, -amount / 2, this.screenRegion.getBounds().width, this.screenRegion.getBounds().height + amount));
        }

        public RelativeScreenRegionBuilder wider(int amount) {
            return new RelativeScreenRegionBuilder(this.screenRegion.getRelativeScreenRegion(-amount / 2, 0, this.screenRegion.getBounds().width + amount, this.screenRegion.getBounds().height));
        }

        public RelativeScreenLocationBuilder center() {
            return new RelativeScreenLocationBuilder(this.screenRegion.getCenter());
        }

        public RelativeScreenLocationBuilder topLeft() {
            return new RelativeScreenLocationBuilder(this.screenRegion.getRelativeScreenLocation(0, 0));
        }

        public RelativeScreenLocationBuilder topRight() {
            Rectangle r = this.screenRegion.getBounds();
            return new RelativeScreenLocationBuilder(this.screenRegion.getRelativeScreenLocation(r.width, 0));
        }

        public RelativeScreenLocationBuilder bottomRight() {
            Rectangle r = this.screenRegion.getBounds();
            return new RelativeScreenLocationBuilder(this.screenRegion.getRelativeScreenLocation(r.width, r.height));
        }

        public RelativeScreenLocationBuilder bottomLeft() {
            Rectangle r = this.screenRegion.getBounds();
            return new RelativeScreenLocationBuilder(this.screenRegion.getRelativeScreenLocation(0, r.height));
        }

        public ScreenRegion getScreenRegion() {
            return this.screenRegion;
        }
    }
}

