/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.api.Screen;
import org.sikuli.api.robot.desktop.AWTDesktop;

public class DesktopScreen
implements Screen {
    private final int screenId;

    public DesktopScreen(int screenId) {
        this.screenId = screenId;
    }

    @Override
    public BufferedImage getScreenshot(int x, int y, int width, int height) {
        BufferedImage image = AWTDesktop.captureScreenshot(this.getId(), x, y, width, height);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return ImageIO.read(is);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Dimension getSize() {
        return AWTDesktop.getScreenBounds(this.getId()).getSize();
    }

    public int getId() {
        return this.screenId;
    }

    public Rectangle getBounds() {
        return AWTDesktop.getScreenBounds(this.getId());
    }
}

