/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.visual.BoxElement;
import org.sikuli.api.visual.CircleElement;
import org.sikuli.api.visual.Element;
import org.sikuli.api.visual.ImageElement;
import org.sikuli.api.visual.LabelElement;

public abstract class Canvas {
    private final List<Element> elements = Lists.newArrayList();

    public StyleBuilder addCircle(ScreenLocation screenLocation) {
        CircleElement newElement = new CircleElement();
        newElement.x = screenLocation.getX() - 10;
        newElement.y = screenLocation.getY() - 10;
        newElement.width = 20;
        newElement.height = 20;
        return this.addElement(newElement);
    }

    public StyleBuilder addImage(ScreenLocation screenLocation, BufferedImage image) {
        ImageElement newElement = new ImageElement();
        newElement.x = screenLocation.getX();
        newElement.y = screenLocation.getY();
        newElement.image = image;
        return this.addElement(newElement);
    }

    public StyleBuilder addBox(ScreenRegion screenRegion) {
        Rectangle r = screenRegion.getBounds();
        BoxElement newElement = new BoxElement();
        newElement.x = r.x;
        newElement.y = r.y;
        newElement.width = r.width;
        newElement.height = r.height;
        return this.addElement(newElement);
    }

    public StyleBuilder addLabel(ScreenRegion screenRegion, String labelText) {
        return this.addLabel(screenRegion.getCenter(), labelText);
    }

    public StyleBuilder addLabel(ScreenLocation screenLocation, String labelText) {
        LabelElement newElement = new LabelElement();
        newElement.text = labelText;
        newElement.x = screenLocation.getX();
        newElement.y = screenLocation.getY();
        return this.addElement(newElement);
    }

    private StyleBuilder addElement(Element element) {
        this.getElements().add(element);
        return new StyleBuilder(element);
    }

    public Canvas clear() {
        this.getElements().clear();
        return this;
    }

    public abstract void display(int var1);

    public abstract BufferedImage createImage();

    protected List<Element> getElements() {
        return this.elements;
    }

    public class StyleBuilder {
        private final Element element;

        public StyleBuilder(Element element) {
            this.element = element;
        }

        public StyleBuilder withLineColor(Color color) {
            this.element.lineColor = color;
            return this;
        }

        public StyleBuilder withColor(Color color) {
            this.element.color = color;
            return this;
        }

        public StyleBuilder withFontSize(int size) {
            this.element.fontSize = size;
            return this;
        }

        public StyleBuilder withLineWidth(int width) {
            this.element.lineWidth = width;
            return this;
        }

        public void display(int seconds) {
            Canvas.this.display(seconds);
        }
    }
}

