/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;

public class MarginFinderOld {
    private static ImageExplainer logger = ImageExplainer.getExplainer(MarginFinderOld.class);

    public static Rectangle getRegionInsideMargin(opencv_core.IplImage gray) {
        int h2 = gray.height();
        int w = gray.width();
        int t = MarginFinderOld.findMarginEndPosition(gray, 0, h2, 1, true);
        int b2 = MarginFinderOld.findMarginEndPosition(gray, h2, 0, -1, true);
        int l2 = MarginFinderOld.findMarginEndPosition(gray, 0, w, 1, false);
        int r = MarginFinderOld.findMarginEndPosition(gray, w, 0, -1, false);
        if (r < l2) {
            l2 = r;
        }
        if (b2 < t) {
            b2 = t;
        }
        Rectangle regionInsideMargin = new Rectangle(l2, t, r - l2, b2 - t);
        ExplainationImageRenderer explainationImageRenderer = new ExplainationImageRenderer(gray.getBufferedImage(), regionInsideMargin);
        logger.result(explainationImageRenderer, (Object)("margin (t=" + t + ", l=" + l2 + ", b=" + b2 + ", r=" + r + ")"));
        return regionInsideMargin;
    }

    public static Rectangle getRegionInsideMargin(BufferedImage input) {
        opencv_core.IplImage gray = ImagePreprocessor.createGrayscale(input);
        return MarginFinderOld.getRegionInsideMargin(gray);
    }

    private static int findMarginEndPosition(opencv_core.IplImage gray, int startPosition, int endPosition, int step, boolean row) {
        int h2 = gray.height();
        int w = gray.width();
        int i2 = startPosition;
        while (i2 + step != endPosition) {
            i2 += step;
            if (row) {
                opencv_core.CvRect rowROI = opencv_core.cvRect(0, i2, w, 1);
                opencv_core.cvSetImageROI(gray, rowROI);
            } else {
                opencv_core.CvRect colROI = opencv_core.cvRect(i2, 0, 1, h2);
                opencv_core.cvSetImageROI(gray, colROI);
            }
            opencv_core.CvScalar mean = new opencv_core.CvScalar();
            opencv_core.CvScalar stdDev = new opencv_core.CvScalar();
            opencv_core.cvAvgSdv(gray, mean, stdDev, null);
            opencv_core.cvResetImageROI(gray);
            if (!(stdDev.getVal(0) > 10.0)) continue;
            return i2;
        }
        return endPosition;
    }

    static class ExplainationImageRenderer
    extends PiccoloImageRenderer
    implements ImageRenderer {
        private final Rectangle r;

        public ExplainationImageRenderer(BufferedImage input, Rectangle r) {
            super(input);
            this.r = r;
        }

        @Override
        protected void addContent(PLayer layer) {
            PPath p = PPath.createRectangle(this.r.x, this.r.y, this.r.width, this.r.height);
            p.setPaint(null);
            p.setStrokePaint(Color.red);
            p.setStroke(new BasicStroke(1.0f));
            layer.addChild(p);
        }
    }
}

