/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.WebDriverException;

public class SessionHelpers {
    private static final Pattern SESSION = Pattern.compile("/session/([^/]+)");

    private SessionHelpers() {
    }

    public static SessionAddress parseSessionAddress(URL address) {
        String addressString = address.toString();
        Matcher matcher = SESSION.matcher(addressString);
        if (!matcher.find()) {
            throw new InvalidArgumentException(String.format("The server URL '%s' must include /session/<id> suffix", addressString));
        }
        try {
            return new SessionAddress(new URL(addressString.replace(matcher.group(), "")), matcher.group(1));
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static class SessionAddress {
        private final URL serverUrl;
        private final String id;

        @Generated
        public SessionAddress(URL serverUrl, String id) {
            this.serverUrl = serverUrl;
            this.id = id;
        }

        @Generated
        public URL getServerUrl() {
            return this.serverUrl;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SessionAddress)) {
                return false;
            }
            SessionAddress other = (SessionAddress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URL this$serverUrl = this.getServerUrl();
            URL other$serverUrl = other.getServerUrl();
            if (this$serverUrl == null ? other$serverUrl != null : !((Object)this$serverUrl).equals(other$serverUrl)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SessionAddress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $serverUrl = this.getServerUrl();
            result = result * 59 + ($serverUrl == null ? 43 : ((Object)$serverUrl).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SessionHelpers.SessionAddress(serverUrl=" + String.valueOf(this.getServerUrl()) + ", id=" + this.getId() + ")";
        }
    }
}

