/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ScreenRecordingUploadOptions {
    private String remotePath;
    private String user;
    private String pass;
    private String method;
    private String fileFieldName;
    private Map<String, String> headers;
    private Map<String, Object> formFields;

    public static ScreenRecordingUploadOptions uploadOptions() {
        return new ScreenRecordingUploadOptions();
    }

    public ScreenRecordingUploadOptions withRemotePath(String remotePath) {
        this.remotePath = Objects.requireNonNull(remotePath);
        return this;
    }

    public ScreenRecordingUploadOptions withAuthCredentials(String user, String pass) {
        this.user = Objects.requireNonNull(user);
        this.pass = Objects.requireNonNull(pass);
        return this;
    }

    public ScreenRecordingUploadOptions withHttpMethod(RequestMethod method) {
        this.method = Objects.requireNonNull(method).name();
        return this;
    }

    public ScreenRecordingUploadOptions withFileFieldName(String fileFieldName) {
        this.fileFieldName = Objects.requireNonNull(fileFieldName);
        return this;
    }

    public ScreenRecordingUploadOptions withFormFields(Map<String, Object> formFields) {
        this.formFields = Objects.requireNonNull(formFields);
        return this;
    }

    public ScreenRecordingUploadOptions withHeaders(Map<String, String> headers) {
        this.headers = Objects.requireNonNull(headers);
        return this;
    }

    public Map<String, Object> build() {
        HashMap map = new HashMap();
        Optional.ofNullable(this.remotePath).map(x -> map.put("remotePath", x));
        Optional.ofNullable(this.user).map(x -> map.put("user", x));
        Optional.ofNullable(this.pass).map(x -> map.put("pass", x));
        Optional.ofNullable(this.method).map(x -> map.put("method", x));
        Optional.ofNullable(this.fileFieldName).map(x -> map.put("fileFieldName", x));
        Optional.ofNullable(this.formFields).map(x -> map.put("formFields", x));
        Optional.ofNullable(this.headers).map(x -> map.put("headers", x));
        return Collections.unmodifiableMap(map);
    }

    public static enum RequestMethod {
        POST,
        PUT;

    }
}

