/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.webui.common.Result;
import com.kms.katalon.core.webui.driver.DriverFactory;
import org.openqa.selenium.Alert;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class EConfirmMessage {
    private static final String JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE = "[JavaScript Error: \"h is null\"";
    private WebDriver driver;
    private Alert alert;
    private Boolean isPresent;

    public EConfirmMessage(WebDriver driver) throws WebDriverException, StepFailedException {
        this.driver = driver;
        this.isPresent = false;
        try {
            this.alert = this.driver.switchTo().alert();
            this.isPresent = true;
        }
        catch (Exception e) {
            if (!(e instanceof NoSuchWindowException) && !e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                return;
            }
            DriverFactory.switchToAvailableWindow();
            this.driver = DriverFactory.getWebDriver();
            this.alert = this.driver.switchTo().alert();
            this.isPresent = true;
        }
    }

    public Result getValue() {
        if (this.isPresent.equals(true)) {
            try {
                return Result.reportHappyCase(this.alert.getText());
            }
            catch (Exception e) {
                return Result.reportUnHappyCase(null, true, "INT110", e.getMessage());
            }
        }
        return Result.reportUnHappyCase(null, false, "INT111", new Object[0]);
    }

    public Result verifyConfirmMessage(String input) {
        Result value = this.getValue();
        if (value.getMessage() == null) {
            if (input == null) {
                if (value.getReturnValue() == null) {
                    return Result.reportHappyCase(true);
                }
                return Result.reportUnHappyCase(false, false, "INT112", value.getReturnValue());
            }
            if (value.getReturnValue() != null) {
                String actualValue = value.getReturnValue().toString();
                boolean matches = false;
                if (input.startsWith("regex=")) {
                    input = input.replace("regex=", "");
                    matches = actualValue.matches(input);
                } else {
                    matches = actualValue.equals(input);
                }
                if (matches) {
                    return Result.reportHappyCase(true);
                }
                return Result.reportUnHappyCase(false, false, "INT114", actualValue, input);
            }
            return Result.reportUnHappyCase(false, false, "INT115", input);
        }
        return Result.reportUnHappyCaseWithMessage(false, value.needReNewDriver(), value.getMessage());
    }

    public Result confirm(String input) {
        block5: {
            try {
                if (this.isPresent.equals(true)) {
                    if (input.equalsIgnoreCase("yes") || input.equalsIgnoreCase("ok")) {
                        this.alert.accept();
                        return Result.reportHappyCase(null);
                    }
                    if (input.equalsIgnoreCase("no") || input.equalsIgnoreCase("cancel")) {
                        this.alert.dismiss();
                        return Result.reportHappyCase(null);
                    }
                    break block5;
                }
                return Result.reportUnHappyCase(null, false, "INT116", new Object[0]);
            }
            catch (Exception e) {
                return Result.reportUnHappyCase(null, true, "INT117", e.getMessage());
            }
        }
        return Result.reportUnHappyCase(null, false, "INT118", new Object[0]);
    }

    public Result setText(String input) {
        try {
            if (this.isPresent.equals(true)) {
                this.driver.switchTo().alert().sendKeys(input);
                return Result.reportHappyCase(null);
            }
            return Result.reportUnHappyCase(null, false, "INT119", new Object[0]);
        }
        catch (Exception e) {
            return Result.reportUnHappyCase(null, true, "INT120", e.getMessage());
        }
    }
}

