/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common.internal;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.common.ScreenUtil;
import com.kms.katalon.core.webui.common.future.AbortSignal;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.sikuli.api.ScreenRegion;

public class ImageLocatorController {
    private static final KeywordLogger logger = KeywordLogger.getInstance(ImageLocatorController.class);

    public static List<WebElement> findElementByScreenShot(WebDriver webDriver, String pathToScreenshot, int timeout) {
        ScreenUtil screen = new ScreenUtil(0.2);
        logger.logInfo("Attempting to find element by its screenshot !");
        if (!new File(pathToScreenshot).exists()) {
            return Collections.emptyList();
        }
        HashMap<ScreenRegion, List<WebElement>> mapOfCandidates = new HashMap<ScreenRegion, List<WebElement>>();
        int iterationCount = 0;
        int scrolledAmount = 0;
        int pageScrollHeight = ImageLocatorController.getPageScrollHeight(webDriver);
        logger.logDebug("Page Scroll Height: " + pageScrollHeight);
        long timeStart = System.currentTimeMillis();
        do {
            try {
                List<ScreenRegion> matchedRegions;
                int viewHeight = ((Number)((JavascriptExecutor)webDriver).executeScript("return window.innerHeight", new Object[0])).intValue();
                int imageHeight = ImageIO.read(new File(pathToScreenshot)).getHeight();
                logger.logDebug(viewHeight + " , " + imageHeight);
                scrolledAmount = iterationCount * Math.abs(viewHeight - imageHeight);
                if (!ImageLocatorController.smoothScroll(webDriver, scrolledAmount) || (matchedRegions = screen.findImages(pathToScreenshot)).size() == 0) break;
                ScreenRegion matchedRegion = matchedRegions.get(0);
                Point coordinatesRelativeToDriver = ImageLocatorController.getCoordinatesRelativeToWebDriver(webDriver, matchedRegion);
                double xRelativeToDriver = coordinatesRelativeToDriver.getX();
                double yRelativeToDriver = coordinatesRelativeToDriver.getY();
                logger.logDebug("Coordinates of matched region relative to driver: (" + xRelativeToDriver + " , " + yRelativeToDriver + ")");
                List<WebElement> elementsAtPointXandY = ImageLocatorController.elementsFromPoint(webDriver, xRelativeToDriver, yRelativeToDriver);
                ImageLocatorController.sortMinimizingDifferencesInSize(elementsAtPointXandY, matchedRegion);
                mapOfCandidates.put(matchedRegion, elementsAtPointXandY);
            }
            catch (Exception exception) {
                logger.logInfo("Unable to find element within the current viewport !");
            }
            ++iterationCount;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        } while (scrolledAmount <= pageScrollHeight || (System.currentTimeMillis() - timeStart) / 1000L < (long)timeout);
        logger.logDebug("Highest matched region's score: " + ImageLocatorController.getHighestMatchedRegionScore(mapOfCandidates));
        ImageLocatorController.debug_printChosenWebElement(pathToScreenshot, webDriver, mapOfCandidates);
        try {
            ImageLocatorController.smoothScroll(webDriver, 0);
        }
        catch (InterruptedException e) {
            logger.logError(e.getMessage());
        }
        return ImageLocatorController.getHighestMatchedRegionWebElements(mapOfCandidates);
    }

    public static List<WebElement> findElementByScreenShot(WebDriver webDriver, String pathToScreenshot, AbortSignal abortSignal) {
        ScreenUtil screen = new ScreenUtil(0.2);
        logger.logInfo("Attempting to find element by its screenshot !");
        if (!new File(pathToScreenshot).exists()) {
            return Collections.emptyList();
        }
        HashMap<ScreenRegion, List<WebElement>> mapOfCandidates = new HashMap<ScreenRegion, List<WebElement>>();
        int iterationCount = 0;
        int scrolledAmount = 0;
        int pageScrollHeight = ImageLocatorController.getPageScrollHeight(webDriver);
        logger.logDebug("Page Scroll Height: " + pageScrollHeight);
        do {
            try {
                List<ScreenRegion> matchedRegions;
                int viewHeight = ((Number)((JavascriptExecutor)webDriver).executeScript("return window.innerHeight", new Object[0])).intValue();
                int imageHeight = ImageIO.read(new File(pathToScreenshot)).getHeight();
                logger.logDebug(viewHeight + " , " + imageHeight);
                scrolledAmount = iterationCount * Math.abs(viewHeight - imageHeight);
                if (!ImageLocatorController.smoothScroll(webDriver, scrolledAmount) || (matchedRegions = screen.findImages(pathToScreenshot)).size() == 0) break;
                ScreenRegion matchedRegion = matchedRegions.get(0);
                Point coordinatesRelativeToDriver = ImageLocatorController.getCoordinatesRelativeToWebDriver(webDriver, matchedRegion);
                double xRelativeToDriver = coordinatesRelativeToDriver.getX();
                double yRelativeToDriver = coordinatesRelativeToDriver.getY();
                logger.logDebug("Coordinates of matched region relative to driver: (" + xRelativeToDriver + " , " + yRelativeToDriver + ")");
                List<WebElement> elementsAtPointXandY = ImageLocatorController.elementsFromPoint(webDriver, xRelativeToDriver, yRelativeToDriver);
                ImageLocatorController.sortMinimizingDifferencesInSize(elementsAtPointXandY, matchedRegion);
                mapOfCandidates.put(matchedRegion, elementsAtPointXandY);
            }
            catch (Exception exception) {
                logger.logInfo("Unable to find element within the current viewport !");
            }
            ++iterationCount;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        } while (scrolledAmount <= pageScrollHeight && !abortSignal.isAborted());
        logger.logDebug("Highest matched region's score: " + ImageLocatorController.getHighestMatchedRegionScore(mapOfCandidates));
        ImageLocatorController.debug_printChosenWebElement(pathToScreenshot, webDriver, mapOfCandidates);
        try {
            ImageLocatorController.smoothScroll(webDriver, 0);
        }
        catch (InterruptedException e) {
            logger.logError(e.getMessage());
        }
        return ImageLocatorController.getHighestMatchedRegionWebElements(mapOfCandidates);
    }

    private static void debug_printChosenWebElement(String pathToScreenshot, WebDriver webDriver, Map<ScreenRegion, List<WebElement>> mapOfCandidates) {
        File screenshotFile = new File(pathToScreenshot);
        File targetFolder = new File(screenshotFile.getParentFile().getAbsolutePath() + "/Matched Elements");
        targetFolder.mkdirs();
        try {
            ImageLocatorController.saveWebElementScreenshot(webDriver, ImageLocatorController.getWebElementOfHighestMatchedRegion(mapOfCandidates), screenshotFile.getName(), targetFolder.getAbsolutePath());
        }
        catch (IOException e) {
            logger.logInfo(e.getMessage());
        }
    }

    private static WebElement getWebElementOfHighestMatchedRegion(Map<ScreenRegion, List<WebElement>> mapOfCandidates) {
        return ImageLocatorController.getHighestMatchedRegionWebElements(mapOfCandidates).stream().findFirst().orElse(null);
    }

    private static List<WebElement> getHighestMatchedRegionWebElements(Map<ScreenRegion, List<WebElement>> mapOfCandidates) {
        return ImageLocatorController.getHighestMatchedRegionEntry(mapOfCandidates).map(entry -> (List)entry.getValue()).orElse(Collections.emptyList());
    }

    private static double getHighestMatchedRegionScore(Map<ScreenRegion, List<WebElement>> mapOfCandidates) {
        return ImageLocatorController.getHighestMatchedRegionEntry(mapOfCandidates).map(entry -> ((ScreenRegion)entry.getKey()).getScore()).orElse(-1.0);
    }

    private static Optional<Map.Entry<ScreenRegion, List<WebElement>>> getHighestMatchedRegionEntry(Map<ScreenRegion, List<WebElement>> mapOfCandidates) {
        return mapOfCandidates.entrySet().stream().max((entry1, entry2) -> {
            double reg2Score;
            double reg1Score = ((ScreenRegion)entry1.getKey()).getScore();
            if (reg1Score < (reg2Score = ((ScreenRegion)entry2.getKey()).getScore())) {
                return -1;
            }
            if (reg1Score > reg2Score) {
                return 1;
            }
            return 0;
        });
    }

    private static boolean smoothScroll(WebDriver webDriver, int heightPos) throws InterruptedException {
        ImageLocatorController.scroll(webDriver, heightPos, true);
        Thread.sleep(700L);
        if (!ImageLocatorController.scroll(webDriver, heightPos)) {
            return false;
        }
        Thread.sleep(100L);
        return true;
    }

    private static boolean scroll(WebDriver webDriver, int heightPos) throws InterruptedException {
        return ImageLocatorController.scroll(webDriver, heightPos, false);
    }

    private static boolean scroll(WebDriver webDriver, int heightPos, boolean smooth) throws InterruptedException {
        try {
            String SCROLL_SCRIPT = MessageFormat.format("window.scrollTo(0, {0})", heightPos);
            String SMOOTH_SCROLL_SCRIPT = MessageFormat.format("window.scrollTo('{'\"top\": {0}, behavior: \"smooth\" '}')", heightPos);
            ((JavascriptExecutor)webDriver).executeScript(smooth ? SMOOTH_SCROLL_SCRIPT : SCROLL_SCRIPT, new Object[0]);
            logger.logDebug(MessageFormat.format("Scrolled to (0, {0})", heightPos));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int getPageScrollHeight(WebDriver webDriver) {
        return ((Number)((JavascriptExecutor)webDriver).executeScript("return document.body.scrollHeight", new Object[0])).intValue();
    }

    private static void sortMinimizingDifferencesInSize(List<WebElement> elementsAtPointXandY, ScreenRegion matchedRegion) {
        elementsAtPointXandY.sort((ele1, ele2) -> {
            double ele2H;
            double ele1H = ImageLocatorController.getDifferenceInSizeHeuristic(ele1, matchedRegion);
            if (ele1H < (ele2H = ImageLocatorController.getDifferenceInSizeHeuristic(ele2, matchedRegion))) {
                return -1;
            }
            if (ele1H > ele2H) {
                return 1;
            }
            return 0;
        });
    }

    private static double getDifferenceInSizeHeuristic(WebElement element, ScreenRegion matchedRegion) {
        double widthDiff = Math.abs((double)element.getRect().getWidth() - matchedRegion.getBounds().getWidth());
        double heightDiff = Math.abs((double)element.getRect().getHeight() - matchedRegion.getBounds().getHeight());
        return widthDiff + heightDiff;
    }

    private static Point getCoordinatesRelativeToWebDriver(WebDriver webDriver, ScreenRegion matchedRegion) {
        JavascriptExecutor js = (JavascriptExecutor)webDriver;
        double viewHeight = ((Number)js.executeScript("return window.innerHeight", new Object[0])).doubleValue();
        double driverHeight = webDriver.manage().window().getSize().getHeight();
        double driverX = webDriver.manage().window().getPosition().getX();
        double driverY = webDriver.manage().window().getPosition().getY();
        double X = matchedRegion.getBounds().getCenterX();
        double Y = matchedRegion.getBounds().getCenterY();
        logger.logDebug("Viewport Height: " + viewHeight);
        logger.logDebug("Driver coordinates: " + driverX + " , " + driverY + ")");
        logger.logDebug("Matched Region center coordinates: (" + X + " , " + Y + ")");
        double xRelativeToDriver = X - driverX;
        double yRelativeToDriver = Y - driverY - (driverHeight - viewHeight);
        return new Point((int)xRelativeToDriver, (int)yRelativeToDriver);
    }

    private static List<WebElement> elementsFromPoint(WebDriver webDriver, double x, double y) {
        List objectsAtPointXandY = (List)((JavascriptExecutor)webDriver).executeScript("return document.elementsFromPoint(arguments[0], arguments[1])", new Object[]{(int)x, (int)y});
        if (objectsAtPointXandY.size() == 0) {
            return Collections.emptyList();
        }
        objectsAtPointXandY.remove(objectsAtPointXandY.size() - 1);
        List<WebElement> elementsAtPointXandY = objectsAtPointXandY.stream().map(e -> (WebElement)e).collect(Collectors.toList());
        return elementsAtPointXandY;
    }

    public static String saveWebElementScreenshot(WebDriver driver, WebElement element, String name, String path) throws IOException {
        if (element == null) {
            return "";
        }
        File screenshot = (File)element.getScreenshotAs(OutputType.FILE);
        BufferedImage screenshotBeforeResized = ImageIO.read(screenshot);
        int eleWidth = element.getRect().getWidth();
        int eleHeight = element.getRect().getHeight();
        BufferedImage screenshotAfterResized = ImageLocatorController.resize(screenshotBeforeResized, eleHeight, eleWidth);
        ImageIO.write((RenderedImage)screenshotAfterResized, "png", screenshot);
        Object screenshotPath = path;
        screenshotPath = ((String)screenshotPath).replaceAll("\\\\", "/");
        screenshotPath = ((String)screenshotPath).endsWith("/") ? (String)screenshotPath + name : (String)screenshotPath + "/" + name;
        if (!((String)screenshotPath).endsWith(".png")) {
            screenshotPath = (String)screenshotPath + ".png";
        }
        File fileScreenshot = new File((String)screenshotPath);
        FileUtils.copyFile((File)screenshot, (File)fileScreenshot);
        screenshot.deleteOnExit();
        return screenshotPath;
    }

    private static BufferedImage resize(BufferedImage img, int height, int width) {
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }
}

