/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.BrokenTestObjects;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectBuilder;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.util.FileUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SelfHealingController {
    private static final String SELF_HEALING_PREFIX = "[WEBUI-SELF-HEALING]";
    public static final String REPORT_FOLDER_NAME = "Reports";
    public static final String SELF_HEALING_FOLDER_NAME = "Self-healing";
    public static final String SELF_HEALING_DATA_FILE_NAME = "broken-test-objects-v2.json";
    public static final String SELF_HEALING_FOLDER_PATH = "Reports/Self-healing";
    private static KeywordLogger logger = KeywordLogger.getInstance(SelfHealingController.class);

    public static void setLogger(KeywordLogger logger) {
        SelfHealingController.logger = logger;
    }

    public static void logInfo(String message) {
        logger.logInfo(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logError(String message) {
        logger.logError(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logError(String message, Throwable throwable) {
        logger.logError(SelfHealingController.selfHealingPrefixify(message), null, throwable);
    }

    public static void logWarning(String message) {
        logger.logWarning(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logWarning(String message, Throwable throwable) {
        logger.logWarning(SelfHealingController.selfHealingPrefixify(message), null, throwable);
    }

    private static String selfHealingPrefixify(String message) {
        return "[WEBUI-SELF-HEALING] " + message;
    }

    public static BrokenTestObject registerBrokenTestObject(TestObject testObject, String proposedLocator, SelectorMethod proposedLocatorMethod, SelectorMethod recoveryMethod, String pathToScreenshot) {
        String dataFolderPath = SelfHealingController.getSelfHealingFolderPath();
        return SelfHealingController.registerBrokenTestObject(testObject, proposedLocator, proposedLocatorMethod, recoveryMethod, pathToScreenshot, dataFolderPath);
    }

    public static BrokenTestObject registerBrokenTestObject(TestObject testObject, String proposedLocator, SelectorMethod proposedLocatorMethod, SelectorMethod recoveryMethod, String pathToScreenshot, String dataFolderPath) {
        String dataFilePath = SelfHealingController.getSelfHealingDataFilePath(dataFolderPath);
        BrokenTestObject brokenTestObject = SelfHealingController.buildBrokenTestObject(testObject, proposedLocator, proposedLocatorMethod, recoveryMethod, pathToScreenshot);
        BrokenTestObjects existingBrokenTestObjects = SelfHealingController.readExistingBrokenTestObjects(dataFilePath);
        if (existingBrokenTestObjects != null) {
            existingBrokenTestObjects.getBrokenTestObjects().add(brokenTestObject);
            SelfHealingController.writeBrokenTestObjects(existingBrokenTestObjects, dataFilePath);
        } else {
            SelfHealingController.logError(dataFilePath + " does not exist or is provided by Self-healing Plugin!");
        }
        return brokenTestObject;
    }

    private static void writeBrokenTestObjects(BrokenTestObjects brokenTestObjects, String filePath) {
        try {
            SelfHealingController.prepareDataFile(filePath);
            FileWriter writer = new FileWriter(filePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)brokenTestObjects, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            SelfHealingController.logError(e.getMessage(), e);
        }
    }

    public static BrokenTestObjects readExistingBrokenTestObjects(String filePath) {
        try {
            SelfHealingController.prepareDataFile(filePath);
            Gson gson = new Gson();
            JsonReader reader = new JsonReader((Reader)new FileReader(filePath));
            BrokenTestObjects brokenTestObjects = (BrokenTestObjects)gson.fromJson(reader, BrokenTestObjects.class);
            reader.close();
            return brokenTestObjects != null ? brokenTestObjects : new BrokenTestObjects();
        }
        catch (Exception e) {
            SelfHealingController.logError(e.getMessage(), e);
            return null;
        }
    }

    public static File prepareDataFile(String dataFilePath) {
        File autoHealingFile = new File(dataFilePath);
        File selfHealingDirectory = autoHealingFile.getParentFile();
        if (!selfHealingDirectory.exists()) {
            selfHealingDirectory.mkdirs();
            if (!selfHealingDirectory.exists()) {
                SelfHealingController.logError(MessageFormat.format("The folder \"{0}\" does not exist, no file is created.", selfHealingDirectory.getAbsolutePath()));
                return null;
            }
        }
        if (!autoHealingFile.exists()) {
            try {
                if (autoHealingFile.createNewFile()) {
                    BrokenTestObjects emptyBrokenTestObjects = new BrokenTestObjects();
                    FileWriter writer = new FileWriter(autoHealingFile.getAbsolutePath());
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((Object)emptyBrokenTestObjects, (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    return autoHealingFile;
                }
            }
            catch (IOException exception) {
                SelfHealingController.logError(exception.getMessage());
                return null;
            }
        }
        return autoHealingFile;
    }

    private static BrokenTestObject buildBrokenTestObject(TestObject testObject, String proposedLocator, SelectorMethod proposedLocatorMethod, SelectorMethod recoveryMethod, String pathToScreenshot) {
        SelectorMethod brokenLocatorMethod = testObject.getSelectorMethod();
        String brokenLocator = (String)testObject.getSelectorCollection().get(brokenLocatorMethod);
        if (brokenLocatorMethod == SelectorMethod.SMART_LOCATOR) {
            brokenLocator = (String)testObject.getSmartSelectorCollection().get(brokenLocatorMethod);
        }
        BrokenTestObject brokenTestObject = new BrokenTestObject();
        brokenTestObject.setTestObjectId(testObject.getObjectId());
        brokenTestObject.setApproved(Boolean.valueOf(true));
        brokenTestObject.setBrokenLocator(brokenLocator);
        brokenTestObject.setBrokenLocatorMethod(brokenLocatorMethod.toString());
        brokenTestObject.setProposedLocator(proposedLocator);
        brokenTestObject.setProposedLocatorMethod(proposedLocatorMethod.toString());
        brokenTestObject.setRecoveryMethod(recoveryMethod.toString());
        brokenTestObject.setPathToScreenshot(pathToScreenshot);
        return brokenTestObject;
    }

    public static Set<BrokenTestObject> findBrokenTestObjects(TestObject testObject) {
        String testObjectId = testObject.getObjectId();
        String selfHealingDataFilePath = SelfHealingController.getSelfHealingDataFilePath();
        BrokenTestObjects existingBrokenTestObjects = SelfHealingController.readExistingBrokenTestObjects(selfHealingDataFilePath);
        if (existingBrokenTestObjects != null) {
            Set brokenTestObjects = existingBrokenTestObjects.getBrokenTestObjects();
            return brokenTestObjects.stream().filter(brokenTestObject -> StringUtils.equals((CharSequence)brokenTestObject.getTestObjectId(), (CharSequence)testObjectId)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static List<TestObject> findHealedTestObjects(TestObject testObject) {
        Set<BrokenTestObject> brokenTestObjects = SelfHealingController.findBrokenTestObjects(testObject);
        if (brokenTestObjects != null && brokenTestObjects != null && !brokenTestObjects.isEmpty()) {
            return brokenTestObjects.stream().map(brokenTestObject -> SelfHealingController.healTestObject(testObject, brokenTestObject)).collect(Collectors.toList());
        }
        return null;
    }

    public static TestObject healTestObject(TestObject testObject, BrokenTestObject brokenTestObject) {
        TestObject clone = new TestObjectBuilder(testObject.getObjectId()).withImagePath(testObject.getImagePath()).withParentObject(testObject.getParentObject()).withProperties(testObject.getProperties()).withSelectorMethod(testObject.getSelectorMethod()).withXPaths(testObject.getXpaths()).withUseRelativeImagePathEqual(testObject.getUseRelativeImagePath()).withSelectorCollection(testObject.getSelectorCollection()).build();
        clone.setSelectorMethod(SelectorMethod.valueOf((String)brokenTestObject.getProposedLocatorMethod()));
        clone.setSelectorValue(SelectorMethod.valueOf((String)brokenTestObject.getProposedLocatorMethod()), brokenTestObject.getProposedLocator());
        return clone;
    }

    public static String getSelfHealingFolderPath() {
        return FilenameUtils.concat((String)RunConfiguration.getProjectDir(), (String)SELF_HEALING_FOLDER_PATH);
    }

    public static String getSelfHealingDataFilePath() {
        return SelfHealingController.getSelfHealingDataFilePath(SelfHealingController.getSelfHealingFolderPath());
    }

    public static String getSelfHealingDataFilePath(String atFolder) {
        return FilenameUtils.concat((String)atFolder, (String)SELF_HEALING_DATA_FILE_NAME);
    }

    public static String takeScreenShot(WebDriver webDriver, WebElement element, String name) {
        String selfHealingFolder = SelfHealingController.getSelfHealingFolderPath();
        try {
            String fullPath = WebUiCommonHelper.saveWebElementScreenshot(webDriver, element, name, selfHealingFolder);
            SelfHealingController.logInfo("Screenshot: " + fullPath);
            return fullPath;
        }
        catch (Exception ex) {
            SelfHealingController.logError(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_SAVE_SCREENSHOT, selfHealingFolder, ex.getMessage()), ex);
            return "";
        }
    }

    public static String takeScreenShot(WebDriver webDriver, WebElement element, TestObject testObject, String name) {
        return SelfHealingController.takeScreenShot(webDriver, element, testObject.getObjectId() + "_" + name);
    }

    public static String getRelativePathToSelfHealindDir(String screenshotAbsolutePath) {
        String selfHealingFolder = SelfHealingController.getSelfHealingFolderPath();
        return FileUtil.getRelativePath(screenshotAbsolutePath, selfHealingFolder);
    }

    public static String getScreenshotAbsolutePath(String screenshotRelativePath) {
        String projectDir = RunConfiguration.getProjectDir();
        return FilenameUtils.concat((String)projectDir, (String)screenshotRelativePath);
    }
}

