/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.google.gson.JsonIOException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverBuilderFactory;
import com.kms.katalon.core.webui.driver.DriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.ExistingRemoteWebDriver;
import com.kms.katalon.core.webui.driver.ExistingSessionDriverBuilder;
import com.kms.katalon.core.webui.driver.IDriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.KatalonSmartEventListener;
import com.kms.katalon.core.webui.driver.WebMobileDriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.driver.chrome.ChromeDriverBuilder;
import com.kms.katalon.core.webui.driver.edge.EdgeChromiumDriverBuilder;
import com.kms.katalon.core.webui.driver.firefox.FirefoxDriverBuilder;
import com.kms.katalon.core.webui.driver.remote.GenericRemoteDriverBuilder;
import com.kms.katalon.core.webui.driver.safari.SafariDriverBuilder;
import com.kms.katalon.core.webui.exception.BrowserNotOpenedException;
import com.kms.katalon.core.webui.util.URLUtils;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.decorators.Decorated;

public class DriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    public static final String WEB_UI_DRIVER_PROPERTY = "WebUI";
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String EXISTING_DRIVER_PROPERTY = "Existing";
    public static final String CHROME_DRIVER_PATH_PROPERTY_KEY = "webdriver.chrome.driver";
    public static final String FIREFOX_DRIVER_PATH_PROPERTY_KEY = "webdriver.gecko.driver";
    private static final String JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE = "[JavaScript Error: \"h is null\"";
    public static final String EDGE_CHROMIUM_DRIVER_PATH_PROPERTY = "edgeChromiumDriverPath";
    public static final String CHROME_DRIVER_PATH_PROPERTY = "chromeDriverPath";
    public static final String ENABLE_PAGE_LOAD_TIMEOUT = "enablePageLoadTimeout";
    public static final String DEFAULT_PAGE_LOAD_TIMEOUT = "defaultPageLoadTimeout";
    public static final String ACTION_DELAY = "actionDelay";
    public static final String USE_ACTION_DELAY_IN_SECOND = "useActionDelayInSecond";
    public static final String IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION = "ignorePageLoadTimeoutException";
    public static final String EXECUTED_BROWSER_PROPERTY = "browserType";
    public static final String REMOTE_WEB_DRIVER_URL = "remoteWebDriverUrl";
    public static final String REMOTE_WEB_DRIVER_TYPE = "remoteWebDriverType";
    public static final String IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED = "isEncrypted";
    public static final String REMOTE_MOBILE_DRIVER = "remoteMobileDriver";
    public static final String DEBUG_PORT = "debugPort";
    public static final String DEBUG_HOST = "debugHost";
    public static final String DEFAULT_DEBUG_HOST = "localhost";
    private static final ThreadLocal<WebDriver> localWebServerStorage = new ThreadLocal<WebDriver>(){

        @Override
        protected WebDriver initialValue() {
            return null;
        }
    };
    private static IDriverConfigurationProvider driverConfigProvider = new DriverConfigurationProvider(logger);

    public static void setDriverConfigurationProvider(IDriverConfigurationProvider provider) {
        driverConfigProvider = provider;
    }

    public static IDriverConfigurationProvider getDriverConfigurationProvider() {
        return driverConfigProvider;
    }

    public static WebDriver openWebDriver() throws Exception {
        try {
            WebDriver webDriver;
            if (DriverFactory.isUsingExistingDriver()) {
                webDriver = DriverFactory.startExistingBrowser();
            } else {
                String remoteWebDriverUrl = DriverFactory.getRemoteWebDriverServerUrl();
                webDriver = StringUtils.isNotEmpty((CharSequence)remoteWebDriverUrl) ? DriverFactory.startRemoteBrowser() : DriverFactory.startNewBrowser(DriverFactory.getExecutedBrowser());
                DriverFactory.saveWebDriverSessionData(webDriver);
                DriverFactory.changeWebDriver(webDriver);
            }
            return webDriver;
        }
        catch (Error e) {
            logger.logMessage(LogLevel.WARNING, e.getMessage(), (Throwable)e);
            throw new StepFailedException((Throwable)e);
        }
    }

    public static void changeWebDriver(WebDriver webDriver) {
        DriverFactory.logBrowserRunData(webDriver);
        DriverFactory.changeWebDriverWithoutLog(webDriver);
    }

    private static void changeWebDriverWithoutLog(WebDriver webDriver) {
        localWebServerStorage.set(webDriver);
        RunConfiguration.storeDriver((Object)webDriver);
        DriverFactory.setTimeout();
    }

    private static boolean isUsingExistingDriver() {
        return RunConfiguration.getDriverSystemProperties((String)EXISTING_DRIVER_PROPERTY) != null;
    }

    private static WebDriver startRemoteBrowser() throws Exception {
        if (localWebServerStorage.get() != null && DriverFactory.getRemoteSessionId(localWebServerStorage.get()) != null) {
            logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_ALREADY_OPENED);
            DriverFactory.closeWebDriver();
        }
        WebUIDriverType driver = WebUIDriverType.REMOTE_WEB_DRIVER;
        String remoteServerUrl = DriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isEmpty((CharSequence)remoteServerUrl)) {
            return null;
        }
        Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)"Remote");
        MutableCapabilities mutableCapabilities = new MutableCapabilities();
        if (driverPreferenceProps != null) {
            mutableCapabilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, driver);
        }
        WebDriver webDriver = new GenericRemoteDriverBuilder().capabilities((Capabilities)mutableCapabilities).withSmartLocator(WebUiCommonHelper.smartLocatorEnabled()).withSmartWait(DriverFactory.globalSmartWaitEnabled()).withFlutterAppTesting(RunConfiguration.isFlutterAppTestingEnabled()).withCanvasTextExtraction(RunConfiguration.isCanvasTextExtractionEnabled()).withClosedShadowDOMTesting(RunConfiguration.isClosedShadowDOMTestingEnabled()).build();
        return webDriver;
    }

    private static WebDriver startNewBrowser(IDriverType executedBrowser) throws Exception {
        WebUIDriverType driverType = (WebUIDriverType)executedBrowser;
        if (driverType == null) {
            throw new StepFailedException(StringConstants.DRI_ERROR_MSG_NO_BROWSER_SET);
        }
        if (localWebServerStorage.get() != null && DriverFactory.getRemoteSessionId(localWebServerStorage.get()) != null) {
            logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_ALREADY_OPENED);
            DriverFactory.closeWebDriver();
        }
        logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_STARTING_DRIVER_X, driverType.toString()));
        Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)WEB_UI_DRIVER_PROPERTY);
        MutableCapabilities capabilities = null;
        if (driverPreferenceProps != null) {
            capabilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, driverType);
        }
        if (capabilities == null) {
            capabilities = new MutableCapabilities();
        }
        WebDriver driver = DriverBuilderFactory.getDriverBuilder(driverType).capabilities((Capabilities)capabilities).withSmartLocator(WebUiCommonHelper.smartLocatorEnabled()).withSmartWait(DriverFactory.globalSmartWaitEnabled()).withFlutterAppTesting(RunConfiguration.isFlutterAppTestingEnabled()).withCanvasTextExtraction(RunConfiguration.isCanvasTextExtractionEnabled()).withClosedShadowDOMTesting(RunConfiguration.isClosedShadowDOMTestingEnabled()).build();
        DriverFactory.checkTimeCapsuleAvailable(driverType);
        return driver;
    }

    private static boolean checkTimeCapsuleAvailable(WebUIDriverType driver) {
        if (!RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
            return false;
        }
        switch (driver) {
            case CHROME_DRIVER: 
            case EDGE_CHROMIUM_DRIVER: 
            case HEADLESS_DRIVER: {
                return true;
            }
        }
        KeywordLogger.getInstance(KatalonSmartEventListener.class).logWarning(CoreWebuiMessageConstants.MSG_TIME_CAPSULE_IS_NOT_SUPPORTED_ON_CURRENT_BROWSER);
        return false;
    }

    private static boolean globalSmartWaitEnabled() {
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        return globalSmartWaitEnabled;
    }

    private static void saveWebDriverSessionData(WebDriver webDriver) {
        block24: {
            if (!(webDriver instanceof RemoteWebDriver) || webDriver instanceof ExistingRemoteWebDriver || webDriver instanceof SafariDriver) {
                return;
            }
            if (RunConfiguration.getRunningMode() == RunningMode.CONSOLE) {
                return;
            }
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriver;
            Socket myClient = null;
            PrintStream output = null;
            try {
                try {
                    HasBiDi webDriverBidi;
                    myClient = new Socket(RunConfiguration.getSessionServerHost(), RunConfiguration.getSessionServerPort());
                    output = new PrintStream(myClient.getOutputStream());
                    output.println(remoteWebDriver.getSessionId());
                    output.println(DriverFactory.getWebDriverServerUrl(remoteWebDriver));
                    IDriverType remoteDriverType = DriverFactory.getExecutedBrowser();
                    output.println(remoteDriverType);
                    output.println(RunConfiguration.getLogFolderPath());
                    if (remoteDriverType == WebUIDriverType.ANDROID_DRIVER) {
                        output.println(WebMobileDriverFactory.getDeviceManufacturer() + " " + WebMobileDriverFactory.getDeviceModel() + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    } else if (remoteDriverType == WebUIDriverType.IOS_DRIVER) {
                        output.println(WebMobileDriverFactory.getDeviceName() + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    }
                    if (webDriver instanceof HasBiDi && (webDriverBidi = (HasBiDi)webDriver).maybeGetBiDi().isPresent()) {
                        output.println(remoteWebDriver.getCapabilities().getCapability("webSocketUrl"));
                    } else {
                        output.println();
                    }
                    output.flush();
                }
                catch (Exception exception) {
                    if (myClient != null) {
                        try {
                            myClient.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        output.close();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (myClient != null) {
                    try {
                        myClient.close();
                    }
                    catch (IOException iOException) {}
                }
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            if (myClient != null) {
                try {
                    myClient.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static String getWebDriverServerUrl(RemoteWebDriver remoteWebDriver) {
        CommandExecutor commandExecutor = remoteWebDriver.getCommandExecutor();
        if (commandExecutor instanceof HttpCommandExecutor) {
            return ((HttpCommandExecutor)commandExecutor).getAddressOfRemoteServer().toString();
        }
        return "";
    }

    protected static WebDriver startExistingBrowser() throws Exception {
        String remoteDriverType = RunConfiguration.getExistingSessionDriverType();
        String sessionId = RunConfiguration.getExistingSessionSessionId();
        String remoteServerUrl = RunConfiguration.getExistingSessionServerUrl();
        String webSocketUrl = RunConfiguration.getExistingSessionWebSocketUrl();
        Object webDriver = WebUIDriverType.ANDROID_DRIVER.toString().equals(remoteDriverType) || WebUIDriverType.IOS_DRIVER.toString().equals(remoteDriverType) ? WebMobileDriverFactory.startExisitingMobileDriver(WebUIDriverType.fromStringValue(remoteDriverType), sessionId, remoteServerUrl) : new ExistingSessionDriverBuilder().remoteServerUrl(remoteServerUrl).sessionId(sessionId).webSocketUrl(webSocketUrl).withSmartLocator(WebUiCommonHelper.smartLocatorEnabled()).withSmartWait(DriverFactory.globalSmartWaitEnabled()).withFlutterAppTesting(RunConfiguration.isFlutterAppTestingEnabled()).withCanvasTextExtraction(RunConfiguration.isCanvasTextExtractionEnabled()).withClosedShadowDOMTesting(RunConfiguration.isClosedShadowDOMTestingEnabled()).build();
        return webDriver;
    }

    private static void logBrowserRunData(WebDriver webDriver) {
        if (webDriver == null) {
            return;
        }
        String serverUrl = DriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isNotEmpty((CharSequence)serverUrl) && webDriver instanceof RemoteWebDriver) {
            String testCloudRemoteOS = RunConfiguration.getDriverSystemProperty((String)"Remote", (String)"testCloudRemoteOS");
            RemoteWebDriver remoteDriver = (RemoteWebDriver)webDriver;
            Capabilities driverCapabilities = remoteDriver.getCapabilities();
            HashMap driverCapabilitiesMapAsDisplay = new HashMap(driverCapabilities.asMap());
            Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)"Remote");
            MutableCapabilities inputDesireCapibilities = null;
            if (driverPreferenceProps != null) {
                Object katalonOptionsObj;
                inputDesireCapibilities = new MutableCapabilities(driverPreferenceProps);
                if (testCloudRemoteOS != null) {
                    driverCapabilitiesMapAsDisplay.put("deviceName", driverPreferenceProps.get("deviceName"));
                    String browserVersion = WebUiCommonHelper.getBrowserVersion(webDriver);
                    if (browserVersion != null && !browserVersion.isEmpty()) {
                        driverCapabilitiesMapAsDisplay.put("browserVersion", browserVersion);
                    }
                }
                if ((katalonOptionsObj = driverPreferenceProps.get("katalon:options")) instanceof Map) {
                    Map katalonOptions = (Map)katalonOptionsObj;
                    String browserVersionTypeObj = (String)katalonOptions.get("browserVersionType");
                    logger.logRunData("browserVersionType", browserVersionTypeObj != null ? browserVersionTypeObj.toString() : "");
                }
            }
            if (testCloudRemoteOS != null) {
                logger.logRunData("remoteDriverUrl", URLUtils.removeCrendentialsFromURL(serverUrl));
                logger.logRunData("remoteOS", testCloudRemoteOS);
                TestCloudPropertyUtil.getInstance().setRunFromTestCloud(driverCapabilitiesMapAsDisplay);
            } else if (!TestCloudPropertyUtil.getInstance().isRunFromTestCloud((Capabilities)inputDesireCapibilities)) {
                logger.logRunData("remoteDriverUrl", serverUrl);
            }
            if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud()) {
                String log = JsonUtil.toJson((Object)TestCloudPropertyUtil.getInstance().hideTestCloudSensitiveDesiredCapabilities(driverCapabilitiesMapAsDisplay));
                log = TestCloudPropertyUtil.getInstance().hideSauceLabsDocumentLink(log);
                logger.logRunData("desiredCapabilities", log);
                Object katalonCaps = driverCapabilitiesMapAsDisplay.get("katalon:caps");
                if (katalonCaps != null && katalonCaps instanceof Map) {
                    String katalonCapsJson = JsonUtil.toJson(katalonCaps);
                    logger.logRunData("katalon:caps", katalonCapsJson);
                    Map katalonCapsMap = (Map)katalonCaps;
                    if (katalonCapsMap.containsKey("deviceName")) {
                        String deviceName = (String)katalonCapsMap.get("deviceName");
                        logger.logRunData("deviceName", deviceName);
                    }
                }
            } else {
                try {
                    logger.logRunData("desiredCapabilities", JsonUtil.toJson(driverCapabilitiesMapAsDisplay));
                }
                catch (JsonIOException jsonIOException) {
                    try {
                        logger.logRunData("desiredCapabilities", JsonUtil.toJson(driverCapabilitiesMapAsDisplay, (boolean)true, (boolean)true));
                    }
                    catch (JsonIOException jsex) {
                        logger.logInfo("Cannot parse driverCapabilities to json - " + jsex.getMessage());
                    }
                }
            }
        }
        logger.logRunData("sessionId", DriverFactory.getRemoteSessionId(webDriver).toString());
        logger.logRunData("browser", DriverFactory.getBrowserVersion(webDriver));
        logger.logRunData("platform", webDriver.getClass() == RemoteWebDriver.class ? ((RemoteWebDriver)webDriver).getCapabilities().getPlatformName().toString() : System.getProperty("os.name"));
        logger.logRunData("seleniumVersion", new BuildInfo().getReleaseLabel());
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        proxyInfo.setPassword("******");
        logger.logRunData("proxyInformation", proxyInfo.toString());
    }

    public static String getBrowserVersion(WebDriver webDriver) {
        try {
            return WebUiCommonHelper.getBrowserAndVersion(DriverFactory.unwrapWebDriver(webDriver));
        }
        catch (Exception e) {
            e = ExceptionsUtil.customException((Exception)e);
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static WebDriver openWebDriver(IDriverType driver, Object options) throws Exception {
        void webUIDriver;
        try {
            if (!(driver instanceof WebUIDriverType)) {
                return null;
            }
            WebUIDriverType webUIDriverType = (WebUIDriverType)driver;
        }
        catch (Error e) {
            logger.logMessage(LogLevel.WARNING, e.getMessage(), (Throwable)e);
            throw new StepFailedException((Throwable)e);
        }
        DriverFactory.closeWebDriver();
        WebDriver webDriver = null;
        switch (DriverFactory.$SWITCH_TABLE$com$kms$katalon$core$webui$driver$WebUIDriverType()[webUIDriver.ordinal()]) {
            case 1: {
                if (options instanceof FirefoxOptions) {
                    FirefoxOptions firefoxOptions = (FirefoxOptions)options;
                    webDriver = new FirefoxDriverBuilder().options(firefoxOptions).build();
                    break;
                }
                if (options instanceof FirefoxProfile) {
                    FirefoxProfile firefoxProfile = (FirefoxProfile)options;
                    webDriver = new FirefoxDriverBuilder().profile(firefoxProfile).build();
                    break;
                }
                if (options instanceof MutableCapabilities) {
                    MutableCapabilities capabilities = (MutableCapabilities)options;
                    webDriver = new FirefoxDriverBuilder().capabilities((Capabilities)capabilities).build();
                    break;
                }
                webDriver = new FirefoxDriverBuilder().build();
                break;
            }
            case 4: {
                if (!(options instanceof MutableCapabilities)) break;
                MutableCapabilities capabilities = (MutableCapabilities)options;
                webDriver = new SafariDriverBuilder().capabilities((Capabilities)capabilities).build();
                break;
            }
            case 3: {
                if (!(options instanceof MutableCapabilities)) break;
                MutableCapabilities capabilities = (MutableCapabilities)options;
                webDriver = new ChromeDriverBuilder().capabilities((Capabilities)capabilities).build();
                break;
            }
            case 9: {
                if (!(options instanceof MutableCapabilities)) break;
                MutableCapabilities capabilities = (MutableCapabilities)options;
                webDriver = new EdgeChromiumDriverBuilder().capabilities((Capabilities)capabilities).build();
                break;
            }
            default: {
                throw new StepFailedException(MessageFormat.format(StringConstants.DRI_ERROR_DRIVER_X_NOT_IMPLEMENTED, driver.getName()));
            }
        }
        localWebServerStorage.set(webDriver);
        DriverFactory.setTimeout();
        return webDriver;
    }

    private static void setTimeout() {
        WebDriver webDriver = localWebServerStorage.get();
        if (webDriver instanceof EdgeDriver) {
            return;
        }
        WebDriver.Timeouts timeouts = webDriver.manage().timeouts();
        timeouts.implicitlyWait(Duration.ofSeconds(0L));
        if (DriverFactory.isEnablePageLoadTimeout()) {
            timeouts.pageLoadTimeout(Duration.ofSeconds(DriverFactory.getDefaultPageLoadTimeout()));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static WebDriver getWebDriver() throws StepFailedException, WebDriverException {
        block4: {
            try {
                DriverFactory.verifyWebDriver();
                break block4;
            }
            catch (BrowserNotOpenedException e) {
                var4_1 = RunConfiguration.getStoredDrivers();
                var3_2 = var4_1.length;
                var2_3 = 0;
                ** while (var2_3 < var3_2)
            }
lbl-1000:
            // 1 sources

            {
                driverObject = var4_1[var2_3];
                if (driverObject instanceof WebDriver && (unwrapped = DriverFactory.unwrapWebDriver(webDriver = (WebDriver)driverObject)) instanceof RemoteWebDriver) {
                    return webDriver;
                }
                ++var2_3;
                continue;
            }
lbl14:
            // 1 sources

            throw e;
        }
        return DriverFactory.localWebServerStorage.get();
    }

    public static WebDriver getUnwrappedWebDriver() throws StepFailedException, WebDriverException {
        return DriverFactory.unwrapWebDriver(DriverFactory.getWebDriver());
    }

    private static void verifyWebDriver() throws StepFailedException, WebDriverException {
        block3: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverFactory.verifyWebDriverIsOpen();
            try {
                if (DriverFactory.getRemoteSessionId(localWebServerStorage.get()) == null) {
                    DriverFactory.switchToAvailableWindow();
                }
            }
            catch (WebDriverException e) {
                if (e instanceof NoSuchWindowException || e.getMessage() == null || e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) break block3;
                throw e;
            }
        }
    }

    private static void verifyWebDriverIsOpen() throws WebDriverException {
        if (localWebServerStorage.get() == null) {
            throw new BrowserNotOpenedException();
        }
    }

    public static Alert getAlert() throws WebDriverException {
        DriverFactory.verifyWebDriverIsOpen();
        Alert alert = null;
        try {
            try {
                alert = localWebServerStorage.get().switchTo().alert();
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                    throw e;
                }
                DriverFactory.switchToAvailableWindow();
                alert = localWebServerStorage.get().switchTo().alert();
            }
            return alert;
        }
        catch (NoAlertPresentException noAlertPresentException) {
            return null;
        }
    }

    public static Alert getAlert(WebDriver driver) throws WebDriverException {
        if (driver == null) {
            throw new BrowserNotOpenedException();
        }
        Alert alert = null;
        try {
            try {
                alert = driver.switchTo().alert();
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                    throw e;
                }
                DriverFactory.switchToAvailableWindow(driver);
                alert = driver.switchTo().alert();
            }
            return alert;
        }
        catch (NoAlertPresentException noAlertPresentException) {
            return null;
        }
    }

    public static boolean waitForAlert(int timeOut) {
        DriverFactory.verifyWebDriverIsOpen();
        float count = 0.0f;
        long miliseconds = System.currentTimeMillis();
        while (count < (float)timeOut) {
            Alert alert = DriverFactory.getAlert();
            if (alert != null) {
                return true;
            }
            count += (float)((System.currentTimeMillis() - miliseconds) / 1000L);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            count = (float)((double)count + 0.5);
            miliseconds = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void switchToAvailableWindow() {
        block6: {
            DriverFactory.verifyWebDriverIsOpen();
            try {
                DriverFactory.localWebServerStorage.get().switchTo().window("");
                break block6;
            }
            catch (WebDriverException e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith("[JavaScript Error: \"h is null\"")) {
                    throw e;
                }
                availableWindows = DriverFactory.localWebServerStorage.get().getWindowHandles();
                ** for (windowId : availableWindows)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    DriverFactory.localWebServerStorage.get().switchTo().window(windowId);
                    return;
                }
                catch (WebDriverException exception) {
                    if (exception instanceof NoSuchWindowException || e.getMessage() == null || exception.getMessage().startsWith("[JavaScript Error: \"h is null\"")) continue;
                    throw exception;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void switchToAvailableWindow(WebDriver driver) {
        block6: {
            try {
                driver.switchTo().window("");
                break block6;
            }
            catch (WebDriverException e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith("[JavaScript Error: \"h is null\"")) {
                    throw e;
                }
                availableWindows = driver.getWindowHandles();
                ** for (windowId : availableWindows)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    driver.switchTo().window(windowId);
                    return;
                }
                catch (WebDriverException exception) {
                    if (exception instanceof NoSuchWindowException || e.getMessage() == null || exception.getMessage().startsWith("[JavaScript Error: \"h is null\"")) continue;
                    throw exception;
                }
            }
        }
    }

    public static int getCurrentWindowIndex() {
        DriverFactory.verifyWebDriverIsOpen();
        String currentWindowHandle = localWebServerStorage.get().getWindowHandle();
        Set availableWindowHandles = localWebServerStorage.get().getWindowHandles();
        int count = 0;
        for (String windowHandle : availableWindowHandles) {
            if (windowHandle.equals(currentWindowHandle)) {
                return count;
            }
            ++count;
        }
        throw new StepFailedException(StringConstants.XML_LOG_ERROR_CANNOT_FOUND_WINDOW_HANDLE);
    }

    private static void startExistingBrowserIfPossible() {
        if (DriverFactory.isUsingExistingDriver() && localWebServerStorage.get() == null) {
            try {
                WebDriver webDriver = DriverFactory.startExistingBrowser();
                DriverFactory.changeWebDriver(webDriver);
            }
            catch (Exception exception) {
                logger.logError("Exception while trying to start existing browser");
            }
        }
    }

    public static boolean isEnablePageLoadTimeout() {
        return RunConfiguration.getBooleanProperty((String)ENABLE_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getDefaultPageLoadTimeout() {
        return RunConfiguration.getIntProperty((String)DEFAULT_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getActionDelay() {
        return driverConfigProvider.getActionDelayInMilisecond();
    }

    public static boolean isIgnorePageLoadTimeoutException() {
        return RunConfiguration.getBooleanProperty((String)IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static IDriverType getExecutedBrowser() {
        WebUIDriverType webDriverType = null;
        if (DriverFactory.isUsingExistingDriver()) {
            webDriverType = WebUIDriverType.fromStringValue(RunConfiguration.getExistingSessionDriverType());
        }
        if (webDriverType != null) {
            return webDriverType;
        }
        String remoteWebDriverUrl = DriverFactory.getRemoteWebDriverServerUrl();
        String driverConnectorProperty = StringUtils.isNotBlank((CharSequence)remoteWebDriverUrl) ? "Remote" : WEB_UI_DRIVER_PROPERTY;
        String driverTypeString = RunConfiguration.getDriverSystemProperty((String)driverConnectorProperty, (String)EXECUTED_BROWSER_PROPERTY);
        if (driverTypeString != null) {
            webDriverType = WebUIDriverType.valueOf(driverTypeString);
        }
        if (webDriverType == null && RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform") != null) {
            webDriverType = WebUIDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform"));
        }
        return webDriverType;
    }

    public static String getRemoteWebDriverServerUrl() {
        boolean isEncrypted;
        String remoteServerUrl = RunConfiguration.getDriverSystemProperty((String)"Remote", (String)REMOTE_WEB_DRIVER_URL);
        Map jsonObjProperties = RunConfiguration.getDriverSystemProperties((String)"Remote");
        if (jsonObjProperties != null && (isEncrypted = RunConfiguration.getBooleanProperty((String)IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED, (Map)jsonObjProperties))) {
            try {
                remoteServerUrl = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)remoteServerUrl));
            }
            catch (IOException | GeneralSecurityException exception) {
                LogUtil.logError((Throwable)exception);
            }
        }
        return remoteServerUrl;
    }

    public static String getRemoteWebDriverServerType() {
        return RunConfiguration.getDriverSystemProperty((String)"Remote", (String)REMOTE_WEB_DRIVER_TYPE);
    }

    public static void closeWebDriver() {
        WebDriver webDriver;
        block8: {
            IDriverType driverType = DriverFactory.getExecutedBrowser();
            webDriver = localWebServerStorage.get();
            if (webDriver != null) {
                try {
                    webDriver.quit();
                    if (driverType instanceof WebUIDriverType) {
                        switch ((WebUIDriverType)driverType) {
                            case ANDROID_DRIVER: 
                            case IOS_DRIVER: {
                                WebMobileDriverFactory.closeDriver();
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (UnreachableBrowserException e) {
                    logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_NOT_REACHABLE, null, (Throwable)e);
                }
                catch (UnsupportedCommandException e) {
                    String message = e.getMessage();
                    if (!StringUtils.isNotEmpty((CharSequence)message)) break block8;
                    logger.logDebug(message);
                }
            }
        }
        localWebServerStorage.set(null);
        RunConfiguration.removeDriver((Object)webDriver);
    }

    private static SessionId getRemoteSessionId(WebDriver webDriver) {
        try {
            WebDriver unwrappedDriver = DriverFactory.unwrapWebDriver(webDriver);
            if (unwrappedDriver instanceof RemoteWebDriver) {
                RemoteWebDriver remoteWebDriver = (RemoteWebDriver)unwrappedDriver;
                return remoteWebDriver.getSessionId();
            }
        }
        catch (Exception e) {
            logger.logInfo(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    private static WebDriver unwrapWebDriver(WebDriver webDriver) {
        WebDriver unwrappedDriver = webDriver;
        if (unwrappedDriver instanceof Decorated) {
            Decorated decoratedDriver = (Decorated)unwrappedDriver;
            unwrappedDriver = (WebDriver)decoratedDriver.getOriginal();
        }
        return unwrappedDriver;
    }
}

