/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileServiceFactory;
import net.sf.jasperreports.data.FileDataAdapter;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.Designated;
import net.sf.jasperreports.engine.util.Designator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.ResourcePropertiesMetadataReader;

public class PropertiesMetadataUtil {
    private JasperReportsContext context;
    private Locale locale;
    private volatile Map<String, PropertyMetadata> loadedProperties;

    public static PropertiesMetadataUtil getInstance(JasperReportsContext context) {
        return new PropertiesMetadataUtil(context, Locale.getDefault());
    }

    public static PropertiesMetadataUtil getInstance(JasperReportsContext context, Locale locale) {
        return new PropertiesMetadataUtil(context, locale);
    }

    protected PropertiesMetadataUtil(JasperReportsContext context, Locale locale) {
        this.context = context;
        this.locale = locale;
    }

    protected Collection<PropertyMetadata> allProperties() {
        Map<String, PropertyMetadata> allProperties = this.loadedProperties;
        if (allProperties == null) {
            this.loadedProperties = allProperties = ResourcePropertiesMetadataReader.instance().readProperties(this.context, this.locale);
        }
        return allProperties.values();
    }

    public List<PropertyMetadata> getProperties() {
        Collection<PropertyMetadata> allProperties = this.allProperties();
        return new ArrayList<PropertyMetadata>(allProperties);
    }

    public List<PropertyMetadata> getProperties(PropertyScope scope) {
        return this.allProperties().stream().filter(this.primaryScopePredicate(scope)).collect(Collectors.toList());
    }

    public List<PropertyMetadata> getQueryExecuterFieldProperties(String queryLanguage) throws JRException {
        String qualification = this.queryExecuterQualification(queryLanguage);
        if (qualification == null) {
            return Collections.emptyList();
        }
        List<PropertyMetadata> properties = this.filterQualifiedProperties(PropertyScope.FIELD, qualification);
        return properties;
    }

    protected String queryExecuterQualification(String queryLanguage) throws JRException {
        QueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getInstance(this.context).getExecuterFactory(queryLanguage);
        if (!(queryExecuterFactory instanceof Designated)) {
            return null;
        }
        String queryExecuterName = ((Designated)((Object)queryExecuterFactory)).getDesignation();
        return queryExecuterName;
    }

    protected List<PropertyMetadata> filterQualifiedProperties(PropertyScope primaryScope, String ... qualifications) {
        return this.qualifiedProperties(primaryScope, qualifications).collect(Collectors.toList());
    }

    protected Stream<PropertyMetadata> qualifiedProperties(PropertyScope primaryScope, String ... qualifications) {
        return this.allProperties().stream().filter(this.scopeQualificationsPredicate(primaryScope, qualifications));
    }

    protected Predicate<PropertyMetadata> primaryScopePredicate(PropertyScope scope) {
        return property -> property.getScopes().contains(scope);
    }

    protected Predicate<PropertyMetadata> scopeQualificationsPredicate(PropertyScope scope, String ... qualifications) {
        Set qualificationSet = Stream.of(qualifications).filter(v -> v != null).collect(Collectors.toSet());
        return this.primaryScopePredicate(scope).and(property -> {
            List<String> propertyQualifications = property.getScopeQualifications();
            return propertyQualifications == null || propertyQualifications.isEmpty() || !Collections.disjoint(propertyQualifications, qualificationSet);
        });
    }

    public List<PropertyMetadata> getParameterProperties(DataAdapter dataAdapter) {
        String qualification = this.dataFileQualification(dataAdapter);
        if (qualification == null) {
            return Collections.emptyList();
        }
        List<PropertyMetadata> properties = this.filterQualifiedProperties(PropertyScope.PARAMETER, qualification);
        return properties;
    }

    protected String dataFileQualification(DataAdapter dataAdapter) {
        String name;
        block2: {
            if (!(dataAdapter instanceof FileDataAdapter)) {
                return null;
            }
            DataFile dataFile = ((FileDataAdapter)dataAdapter).getDataFile();
            name = null;
            List<DataFileServiceFactory> factories = this.context.getExtensions(DataFileServiceFactory.class);
            if (factories == null) break block2;
            for (DataFileServiceFactory factory : factories) {
                if (factory instanceof Designator && (name = ((Designator)((Object)factory)).getName(dataFile)) != null) break;
            }
        }
        return name;
    }

    public List<PropertyMetadata> getElementProperties(JRElement element) {
        Collection<PropertyMetadata> allProperties = this.allProperties();
        ArrayList<PropertyMetadata> elementProperties = new ArrayList<PropertyMetadata>();
        for (PropertyMetadata propertyMetadata : allProperties) {
            if (!this.inScope(propertyMetadata, element)) continue;
            elementProperties.add(propertyMetadata);
        }
        return elementProperties;
    }

    protected boolean inScope(PropertyMetadata property, JRElement element) {
        List<PropertyScope> scopes = property.getScopes();
        if (scopes.contains(PropertyScope.ELEMENT)) {
            return true;
        }
        if (element instanceof JRTextElement && scopes.contains(PropertyScope.TEXT_ELEMENT)) {
            return true;
        }
        if (element instanceof JRImage && scopes.contains(PropertyScope.IMAGE_ELEMENT)) {
            return true;
        }
        if (element instanceof JRChart && scopes.contains(PropertyScope.CHART_ELEMENT)) {
            return true;
        }
        if (element instanceof JRCrosstab && scopes.contains(PropertyScope.CROSSTAB)) {
            return true;
        }
        if (element instanceof JRFrame && scopes.contains(PropertyScope.FRAME)) {
            return true;
        }
        if (element instanceof JRSubreport && scopes.contains(PropertyScope.SUBREPORT)) {
            return true;
        }
        if (element instanceof JRComponentElement && scopes.contains(PropertyScope.COMPONENT)) {
            ComponentKey key;
            List<String> qualifications = property.getScopeQualifications();
            if (qualifications == null || qualifications.isEmpty()) {
                return true;
            }
            JRComponentElement componentElement = (JRComponentElement)element;
            Object qualification = componentElement.getComponent() instanceof Designated ? ((Designated)((Object)componentElement.getComponent())).getDesignation() : ((key = componentElement.getComponentKey()) == null || key.getNamespace() == null || key.getName() == null ? null : key.getNamespace() + ":" + key.getName());
            return qualification != null && qualifications.contains(qualification);
        }
        return false;
    }

    public List<PropertyMetadata> getReportProperties(JRReport report) {
        return this.getProperties(PropertyScope.REPORT);
    }

    protected String datasetQueryQualification(JRDataset dataset) throws JRException {
        String queryLanguage = dataset.getQuery() == null ? null : dataset.getQuery().getLanguage();
        String queryQualification = queryLanguage == null ? null : this.queryExecuterQualification(queryLanguage);
        return queryQualification;
    }

    protected String dataAdapterQualification(JRDataset dataset, DataAdapter dataAdapter) {
        ParameterContributorContext contributorContext = new ParameterContributorContext(this.context, dataset, Collections.emptyMap());
        DataAdapterServiceUtil serviceUtil = DataAdapterServiceUtil.getInstance(contributorContext);
        DataAdapterService service = serviceUtil.getService(dataAdapter);
        if (service instanceof Designated) {
            return ((Designated)((Object)service)).getDesignation();
        }
        if (service instanceof Designator) {
            return ((Designator)((Object)service)).getName(dataAdapter);
        }
        return null;
    }

    public List<PropertyMetadata> getDatasetProperties(JRDataset dataset, DataAdapter dataAdapter) throws JRException {
        String queryQualification = this.datasetQueryQualification(dataset);
        String dataAdapterQualification = dataAdapter == null ? null : this.dataAdapterQualification(dataset, dataAdapter);
        String dataFileQualification = dataAdapter == null ? null : this.dataFileQualification(dataAdapter);
        return this.filterQualifiedProperties(PropertyScope.DATASET, queryQualification, dataAdapterQualification, dataFileQualification);
    }

    public List<PropertyMetadata> getFieldProperties(JRDataset dataset, DataAdapter dataAdapter) throws JRException {
        String queryQualification = this.datasetQueryQualification(dataset);
        String dataAdapterQualification = dataAdapter == null ? null : this.dataAdapterQualification(dataset, dataAdapter);
        return this.filterQualifiedProperties(PropertyScope.FIELD, queryQualification, dataAdapterQualification);
    }

    public List<PropertyMetadata> getContainerProperties(JRElementGroup container) {
        Collection<PropertyMetadata> allProperties = this.allProperties();
        ArrayList<PropertyMetadata> containerProperties = new ArrayList<PropertyMetadata>();
        for (PropertyMetadata propertyMetadata : allProperties) {
            if (!this.inScope(propertyMetadata, container)) continue;
            containerProperties.add(propertyMetadata);
        }
        return containerProperties;
    }

    protected boolean inScope(PropertyMetadata propertyMetadata, JRElementGroup container) {
        if (container instanceof JRFrame) {
            return this.inScope(propertyMetadata, (JRElement)((Object)container));
        }
        List<PropertyScope> scopes = propertyMetadata.getScopes();
        if (container instanceof JRBand) {
            return scopes.contains(PropertyScope.BAND);
        }
        if (container instanceof Cell) {
            return scopes.contains(PropertyScope.TABLE_CELL);
        }
        if (container instanceof JRCellContents) {
            return scopes.contains(PropertyScope.CROSSTAB_CELL);
        }
        return false;
    }

    public List<PropertyMetadata> getScriptletProperties(String scriptletClassName) throws JRException {
        Class<?> scriptletClass;
        try {
            scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Could not load scriptlet class " + scriptletClassName, e);
        }
        Stream<Object> properties = Stream.empty();
        do {
            String qualification = scriptletClass.getName();
            Stream<PropertyMetadata> qualifiedProperties = this.qualifiedProperties(PropertyScope.SCRIPTLET, qualification);
            properties = Stream.concat(properties, qualifiedProperties);
        } while ((scriptletClass = scriptletClass.getSuperclass()) != null && JRAbstractScriptlet.class.isAssignableFrom(scriptletClass));
        return properties.collect(Collectors.toList());
    }
}

