package com.kms.katalon.core.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DBConnectionProperties implements Serializable {
    public static final String WRN_DUPLICATED_NAME = "The property name already exists.";

    private static final long serialVersionUID = 1L;

    private List<ConnectionProperty> connectionProperty;

    private Properties props;

    public DBConnectionProperties() {
        connectionProperty = new ArrayList<ConnectionProperty>();
        props = new Properties();
    }

    public DBConnectionProperties(List<ConnectionProperty> props) {
        this.connectionProperty = props;
        this.props = new Properties();
    }

    public List<ConnectionProperty> getConnectionProperty() {
        return connectionProperty;
    }

    public void setConnectionProperty(List<ConnectionProperty> connectionProperties) {
        this.connectionProperty = connectionProperties;
    }

    public Properties convertListToProperties() {
        props = new Properties();
        for (ConnectionProperty prop : connectionProperty) {
            props.put(prop.getName(), prop.getValue());
        }
        return props;
    }

    public static Properties convertListToProperties(List<ConnectionProperty> listPropeties) {
        Properties properties = new Properties();
        for (ConnectionProperty prop : listPropeties) {
            properties.put(prop.getName(), prop.getValue());
        }
        return properties;
    }

    private static int checkConnectionPropertyNameDuplicated(String name,
            List<ConnectionProperty> connectionProperties) {
        for (int i = 0; i < connectionProperties.size(); i++) {
            if (connectionProperties.get(i).getName().equals(name)) {
                return i;
            }
        }
        return -1;
    }

    public static boolean isConnectionPropertyNameDuplicated(String name,
            List<ConnectionProperty> connectionProperties) {
        return checkConnectionPropertyNameDuplicated(name, connectionProperties) != -1;
    }
}
