package com.kms.katalon.core.logging.model;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.kms.katalon.core.logging.model.TestStatus.TestStatusValue;

public class TestSuiteCollectionLogRecord {

    private String id;

    private String name;

    private String reportFolder;

    private List<TestSuiteLogRecord> testSuiteRecords;

    private long startTime;

    private long endTime;

    private String totalPassedTestCases;

    private String totalErrorTestCases;

    private String totalFailedTestCases;

    private String totalTestCases;

    private String totalIncompleteTestCases;

    private String totalSkippedTestCases;

    private String description;

    public TestSuiteCollectionLogRecord() {
    }

    private TestSuiteCollectionLogRecord(String id, String name, String reportFolder,
            List<TestSuiteLogRecord> testSuiteRecords, long startTime, long endTime, String totalPassedTestCases,
            String totalErrorTestCases, String totalFailedTestCases, String totalTestCases,
            String totalIncompleteTestCases, String totalSkippedTestCases, String description) {
        this.id = id;
        this.name = name;
        this.reportFolder = reportFolder;
        this.testSuiteRecords = testSuiteRecords;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalPassedTestCases = totalPassedTestCases;
        this.totalErrorTestCases = totalErrorTestCases;
        this.totalFailedTestCases = totalFailedTestCases;
        this.totalTestCases = totalTestCases;
        this.totalIncompleteTestCases = totalIncompleteTestCases;
        this.totalSkippedTestCases = totalSkippedTestCases;
        this.description = description;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReportFolder() {
        return reportFolder;
    }

    public void setReportFolder(String reportLocation) {
        this.reportFolder = reportLocation;
    }

    public List<TestSuiteLogRecord> getTestSuiteRecords() {
        return testSuiteRecords;
    }

    public void setTestSuiteRecords(List<TestSuiteLogRecord> testSuiteRecords) {
        this.testSuiteRecords = testSuiteRecords;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getTotalPassedTestCases() {
        return totalPassedTestCases;
    }

    public void setTotalPassedTestCases(String totalPassedTestCases) {
        this.totalPassedTestCases = totalPassedTestCases;
    }

    public String getTotalErrorTestCases() {
        return totalErrorTestCases;
    }

    public void setTotalErrorTestCases(String totalErrorTestCases) {
        this.totalErrorTestCases = totalErrorTestCases;
    }

    public String getTotalFailedTestCases() {
        return totalFailedTestCases;
    }

    public void setTotalFailedTestCases(String totalFailedTestCases) {
        this.totalFailedTestCases = totalFailedTestCases;
    }

    public String getTotalTestCases() {
        return totalTestCases;
    }

    public void setTotalTestCases(String totalTestCases) {
        this.totalTestCases = totalTestCases;
    }

    @Override
    public TestSuiteCollectionLogRecord clone() {
        return new TestSuiteCollectionLogRecord(getId(), getName(), getReportFolder(), getTestSuiteRecords(),
                getStartTime(), getEndTime(), getTotalPassedTestCases(), getTotalErrorTestCases(),
                getTotalFailedTestCases(), getTotalTestCases(), getTotalIncompleteTestCases(),
                getTotalSkippedTestCases(), getDescription());
    }

    public String getTotalIncompleteTestCases() {
        return totalIncompleteTestCases;
    }

    public void setTotalIncompleteTestCases(String totalIncompleteTestCases) {
        this.totalIncompleteTestCases = totalIncompleteTestCases;
    }

    public String getTotalSkippedTestCases() {
        return totalSkippedTestCases;
    }

    public void setTotalSkippedTestCases(String totalSkippedTestCases) {
        this.totalSkippedTestCases = totalSkippedTestCases;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TestStatusValue getStatus() {
        Set<TestStatusValue> statuses = getTestSuiteRecords().stream()
                .map(testSuite -> testSuite.getStatus().getStatusValue())
                .collect(Collectors.toSet());

        // Priority order: ERROR > FAILED > PASSED > SKIPPED
        if (statuses.contains(TestStatusValue.ERROR)) {
            return TestStatusValue.ERROR;
        }
        if (statuses.contains(TestStatusValue.FAILED)) {
            return TestStatusValue.FAILED;
        }
        if (statuses.contains(TestStatusValue.PASSED)) {
            return TestStatusValue.PASSED;
        }
        if (statuses.contains(TestStatusValue.SKIPPED)) {
            return TestStatusValue.SKIPPED;
        }

        return TestStatusValue.INCOMPLETE;
    }
}
