package com.kms.katalon.core.main;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.commons.io.FileUtils;

import com.kms.katalon.core.common.CommonExecutor;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;

import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.JsonUtil;


public class TestCaseBindingExecutor extends CommonExecutor {

    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    private InternalTestSuiteContext testSuiteContext;

    private String testCaseId;

    protected ScriptEngine scriptEngine;

    protected ExecutionEventManager eventManger;

    public TestCaseBindingExecutor(String testCaseId, ScriptEngine scriptEngine, ExecutionEventManager eventManger) {
        this.testCaseId = testCaseId;
        this.scriptEngine = scriptEngine;
        this.eventManger = eventManger;
        this.testSuiteContext = new InternalTestSuiteContext();
        testSuiteContext.setTestSuiteId(testCaseId);
    }

    public void execute(File testCaseBindingFile) {
        logger.startTestCaseBinding(testCaseId);

        accessTestCaseBindingMainPhase(testCaseBindingFile);

        setStatusTestSuiteContext(testSuiteContext);

        logger.endTestCaseBinding(testCaseId);

    }

    private void accessTestCaseBindingMainPhase(File testCaseBindingFile) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();

        if (errorCollector.containsErrors()) {
            return;
        }

        try {
            List<String> bindings = FileUtils.readLines(testCaseBindingFile, "UTF-8");
            if (bindings.isEmpty()) {
                accessTestCaseMainPhase(1, new TestCaseBinding(testCaseId, Collections.emptyMap()));
            } else {
                for (int i = 0; i < bindings.size(); i++) {
                    TestCaseBinding testCaseBinding = JsonUtil.fromJson(bindings.get(i), TestCaseBinding.class);
                    accessTestCaseMainPhaseLoop(scriptEngine, testCaseBinding);
                    accessTestCaseMainPhase(i, testCaseBinding);
                }
            }
        } catch (IOException e) {
            errorCollector.addError(e);
        }

    }

    @Override
    public TestCaseExecutor accessTestCaseMainPhaseBody(TestCaseBinding tcBinding,
            InternalTestCaseContext testCaseContext) {
        return new TestCaseExecutor(tcBinding, scriptEngine, eventManger, testCaseContext);
    }

}
