package com.kms.katalon.core.network;

import java.util.Arrays;

import org.apache.commons.lang.StringUtils;

import com.kms.katalon.network.core.model.config.ManualProxyConfig;
import com.kms.katalon.network.core.model.config.NoProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyBasicAuthentication;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyProtocol;
import com.kms.katalon.network.core.model.config.SystemProxyConfig;

public class ProxyInformation {
    private String proxyOption;

    private String proxyServerType;

    private String username;

    private String password;

    private String proxyServerAddress;
    
    private int proxyServerPort;
    
    private String exceptionList;
    
    private boolean applyToDesiredCapabilities;
    
    public String getExceptionList() {
        return exceptionList;
    }

    public void setExceptionList(String exceptionList) {
        this.exceptionList = StringUtils.isNotEmpty(exceptionList) ? exceptionList : "";
    }

    public String getProxyOption() {
        return proxyOption;
    }

    public void setProxyOption(String proxyOption) {
        if (StringUtils.isEmpty(proxyOption)) {
            proxyOption = ProxyOption.NO_PROXY.name();
        }
        this.proxyOption = proxyOption;
    }

    public String getProxyServerType() {
        return proxyServerType;
    }

    public void setProxyServerType(String proxyServerType) {
        this.proxyServerType = StringUtils.isNotEmpty(proxyServerType) ? proxyServerType : "";
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.isNotEmpty(username) ? username : "";
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isNotEmpty(password) ? password : "";
    }

    public String getProxyServerAddress() {
        return proxyServerAddress;
    }

    public void setProxyServerAddress(String proxyServerAddress) {
        this.proxyServerAddress = StringUtils.isNotEmpty(proxyServerAddress) ? proxyServerAddress : "";
    }

    public int getProxyServerPort() {
        return proxyServerPort;
    }

    public void setProxyServerPort(int proxyServerPort) {
        this.proxyServerPort = proxyServerPort;
    }

    public void setProxyServerPort(String proxyServerPort) {
        try {
            this.proxyServerPort = Integer.parseInt(StringUtils.isNotEmpty(proxyServerPort) ? proxyServerPort : "-1");
        } catch (NumberFormatException ex) {
            this.proxyServerPort = -1;
        }
    }

    public boolean isApplyToDesiredCapabilities() {
        return applyToDesiredCapabilities;
    }

    public void setApplyToDesiredCapabilities(boolean applyToDesiredCapabilities) {
        this.applyToDesiredCapabilities = applyToDesiredCapabilities;
    }

    @Override
    public String toString() {
        return "ProxyInformation { "
                + "proxyOption=" + proxyOption + ", "
                + "proxyServerType=" + proxyServerType + ", "
                + "username=" + username + ", "
                + "password=" + "********" + ", "
                + "proxyServerAddress=" + proxyServerAddress + ", "
                + "proxyServerPort=" + proxyServerPort + ", "
                + "executionList=\"" + exceptionList + "\", "
                + "isApplyToDesiredCapabilities=" + applyToDesiredCapabilities
                + " }";
    }

    public ProxyConfig toNewProxyConfigModel() {
        if (ProxyOption.valueOf(proxyOption).equals(ProxyOption.NO_PROXY)) {
            return new NoProxyConfig();
        }

        if (ProxyOption.valueOf(proxyOption).equals(ProxyOption.USE_SYSTEM)) {
            return new SystemProxyConfig();
        }

        ManualProxyConfig.Builder manualProxyConfigBuilder = new ManualProxyConfig.Builder();
        ProxyProtocol proxyProtocol = ProxyProtocol.valueOf(proxyServerType);
        if (proxyProtocol != null) {
            manualProxyConfigBuilder.protocol(proxyProtocol);
        }

        if (StringUtils.isNotBlank(proxyServerAddress)) {
            manualProxyConfigBuilder.address(proxyServerAddress);
        }

        if (proxyServerPort > 0) {
            manualProxyConfigBuilder.port(proxyServerPort);
        }

        if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(password)) {
            manualProxyConfigBuilder.authentication(new ProxyBasicAuthentication(username, password));
        }

        if (StringUtils.isNotBlank(exceptionList)) {
            manualProxyConfigBuilder
                    .bypassedHosts(Arrays.stream(exceptionList.split("[,;\n]")).map(String::trim).toList());
        }

        return manualProxyConfigBuilder.build();
    }
}
