package com.kms.katalon.core.testcase;

public class VariableReport extends Variable {

    private String value;

    private final boolean isDefault;

    public static VariableReport value(String value, String name, boolean isMasked) {
        return new VariableReport(value, name, isMasked, false);
    }

    public static VariableReport defaultValue(String value, String name, boolean isMasked) {
        return new VariableReport(value, name, isMasked, true);
    }

    public VariableReport(String value, String name, boolean isMasked, boolean isDefaultValue) {
        super.setName(name);
        super.setMasked(isMasked);
        this.value = value;
        this.isDefault = isDefaultValue;
    }

    public String getDisplayReportName() {
        var displayName = getName();

        // Checking start with "(Default)" to avoid adding "(Default)" twice.
        // That's obsoleted behavior which adding "(Default)" to the variable name.
        if (isDefault && !displayName.startsWith("(Default)")) {
            displayName = "(Default) " + displayName;
        }

        return displayName.length() > 15 ? displayName.substring(0, 15) + "..." : displayName;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
