package com.kms.katalon.core.testobject;

import java.util.List;
import java.util.Map;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;

public class TestObjectBuilder {
    private TestObject testObject;

    public TestObjectBuilder(String objectId) {
        testObject = new TestObject(objectId);
    }

    // New constructor to accept TestObject or MobileTestObject
    public TestObjectBuilder(TestObject inputObject) {
        if (inputObject instanceof MobileTestObject) {
            MobileTestObject mobileInput = (MobileTestObject) inputObject;
            MobileTestObject mobileTestObject = new MobileTestObject(mobileInput.getObjectId());
            // Copy mobile-specific fields
            mobileTestObject.setLocator(mobileInput.getLocator());
            mobileTestObject.setLocatorStrategy(mobileInput.getLocatorStrategy());
            mobileTestObject.setLocatorCollection(mobileInput.getLocatorCollection());

            // Copy common fields
            copyCommonFields(mobileInput, mobileTestObject);
            testObject = mobileTestObject;
        } else {
            TestObject newTestObject = new TestObject(inputObject.getObjectId());
            newTestObject.setSelectorMethod(inputObject.getSelectorMethod());
            newTestObject.setSmartSelectorCollection(inputObject.getSmartSelectorCollection());

            // Copy common fields
            copyCommonFields(inputObject, newTestObject);
            testObject = newTestObject;
        }
    }

    // Helper to copy common fields
    private void copyCommonFields(TestObject from, TestObject to) {
        to.setParentObject(from.getParentObject());
        to.setParentObjectShadowRoot(from.isParentObjectShadowRoot());
        to.setProperties(from.getProperties());
        to.setXpaths(from.getXpaths());
        to.setImagePath(from.getImagePath());
        to.setUseRelativeImagePath(from.getUseRelativeImagePath());
    }

    public TestObjectBuilder withParentObject(TestObject parentObject) {
        testObject.setParentObject(parentObject);
        return this;
    }

    public TestObjectBuilder withIsParentObjectShadowRootEqual(boolean val) {
        testObject.setParentObjectShadowRoot(val);
        return this;
    }

    public TestObjectBuilder withProperties(List<TestObjectProperty> properties) {
        testObject.setProperties(properties);
        return this;
    }

    public TestObjectBuilder withXPaths(List<TestObjectXpath> xpaths) {
        testObject.setXpaths(xpaths);
        return this;
    }

    public TestObjectBuilder withImagePath(String path) {
        testObject.setImagePath(path);
        return this;
    }

    public TestObjectBuilder withUseRelativeImagePathEqual(boolean val) {
        testObject.setUseRelativeImagePath(val);
        return this;
    }

    public TestObjectBuilder withSelectorMethod(SelectorMethod selectorMethod) {
        testObject.setSelectorMethod(selectorMethod);
        return this;
    }

    public TestObjectBuilder setSelectorValue(SelectorMethod selectorMethod, String selectorValue) {
        testObject.setSelectorValue(selectorMethod, selectorValue);
        return this;
    }

    public TestObjectBuilder withSelectorCollection(Map<SelectorMethod, String> selectorCollection) {
        selectorCollection.forEach((selectorMethod, selectorValue) -> {
            setSelectorValue(selectorMethod, selectorValue);
        });
        return this;
    }

    public TestObjectBuilder withMobileLocator(String mobileLocator) {
        if (testObject instanceof MobileTestObject) {
            ((MobileTestObject) testObject).setLocator(mobileLocator);
        }
        return this;
    }

    public TestObjectBuilder withMobileLocatorStrategy(LocatorStrategy strategy) {
        if (testObject instanceof MobileTestObject) {
            ((MobileTestObject) testObject).setLocatorStrategy(strategy);
        }
        return this;
    }

    public TestObject build() {
        return testObject;
    }

}
