package com.kms.katalon.core.testobject.authorization;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.kms.katalon.util.CryptoUtil;    

/**
 * Represents NTLM Authorization of a request object
 * 
 * @param username The user name. This should not include the domain to authenticate with.
 * For example: "user" is correct whereas "DOMAIN&#x5c;user" is not.
 * @param password The password.
 * @param workstation The workstation from the authentication request is originating from.
 * Essentially, the computer name for this machine.
 * @param domain The domain to authenticate within.
 * @since 8.4.0
 */

public class NTLMAuthorization extends BasicRequestAuthorization {
    
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public static final String USERNAME = "username";
    
    public static final String PASSWORD = "password";
    
    public static final String DOMAIN = "domain";
    
    public static final String WORKSTATION = "workstation";
    
    public static final String NTLM = "NTLM";
    
    public NTLMAuthorization(String username, String password) {
        this(username, password, StringUtils.EMPTY, StringUtils.EMPTY);
    }

    public NTLMAuthorization(String username, String password, String domain, String workstation) {
        Map<String, String> authorizationInfo = new HashMap<String, String>();
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault(password);
        String encryptPassword = StringUtils.EMPTY;
        try {
            encryptPassword = CryptoUtil.encode(cryptoInfo);
        } catch (UnsupportedEncodingException | GeneralSecurityException e) {
            e.printStackTrace();
        }
        authorizationInfo.put(USERNAME, username);
        authorizationInfo.put(PASSWORD, encryptPassword);
        authorizationInfo.put(DOMAIN, domain);
        authorizationInfo.put(WORKSTATION, workstation);
        this.setAuthorizationType(NTLM);
        this.setAuthorizationInfo(authorizationInfo);
    }
}
