package com.kms.katalon.core.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class ConsoleCommandBuilder {
	private static final String PATH = "PATH";

	private String beforeCommand;

	private String command;

	private String workingDir;

	private boolean redirectError;

	private Map<String, String> envs = new HashMap<String, String>();

	private String path = StringUtils.EMPTY;

	private ConsoleCommandBuilder() {
		// Hide the default constructor
	}

	public static ConsoleCommandBuilder create(String command) {
		return new ConsoleCommandBuilder().command(command);
	}

	public ConsoleCommandBuilder command(String command) {
		this.command = StringUtils.defaultString(command);
		return this;
	}

	public ConsoleCommandBuilder path(String path) {
		this.path = StringUtils.defaultString(path);
		return this;
	}

	public ConsoleCommandBuilder addPath(String additionalPath) {
		if (StringUtils.isBlank(additionalPath)) {
			return this;
		}
		path += File.pathSeparator + additionalPath;
		return this;
	}

	public ConsoleCommandBuilder envs(Map<String, String> envs) {
		this.envs = envs;
		return this;
	}

	public ConsoleCommandBuilder env(String name, String value) {
		envs.put(name, value);
		return this;
	}

	public ConsoleCommandBuilder useSystemEnvs() {
		this.beforeCommand = ConsoleCommandExecutor.getSourcesLoadingCommand();
		return this;
	}

	public ConsoleCommandBuilder workingDir(String workingDir) {
		this.workingDir = workingDir;
		return this;
	}

	public ConsoleCommandBuilder redirectError() {
		return redirectError(true);
	}

	public ConsoleCommandBuilder redirectError(boolean redirectError) {
		this.redirectError = redirectError;
		return this;
	}

	private String buildCommand() {
		return StringUtils.isNotBlank(beforeCommand) ? beforeCommand + "; " + command : command;
	}

	public Process exec() throws IOException {
		envs.put(PATH, path);
		return ConsoleCommandExecutor.exec(buildCommand(), workingDir, redirectError, envs);
	}

	public List<String> execSync() throws IOException, InterruptedException {
		envs.put(PATH, path);
		return ConsoleCommandExecutor.execSync(buildCommand(), workingDir, redirectError, envs);
	}

	public String first() throws IOException, InterruptedException {
		envs.put(PATH, path);
		List<String> results = ConsoleCommandExecutor.execSync(buildCommand(), workingDir, redirectError, envs);
		return results != null && !results.isEmpty() ? results.get(0) : null;
	}
}
