package com.kms.katalon.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;

import javax.activation.MimetypesFileTypeMap;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MimeTypeUtil {
    private MimeTypeUtil() {
        // Hide the default Constructor
    }

    public static String getMimeType(String filePath) {
        String mimeType = null;

        mimeType = MimetypesFileTypeMapUtil.getContentType(FilenameUtils.getExtension(filePath));
        if (StringUtils.isNotBlank(mimeType)) {
            return mimeType;
        }

        try {
            mimeType = Files.probeContentType(Paths.get(filePath));
            if (StringUtils.isNotBlank(mimeType)) {
                return mimeType;
            }
        } catch (IOException e) {
            // Just skip
        }

        mimeType = URLConnection.guessContentTypeFromName(filePath);
        if (StringUtils.isNotBlank(mimeType)) {
            return mimeType;
        }

        URLConnection connection;
        try {
            connection = (new File(filePath)).toURI().toURL().openConnection();
            mimeType = connection.getContentType();
            if (StringUtils.isNotBlank(mimeType) && !StringUtils.equals(mimeType, "content/unknown")) {
                return mimeType;
            }
        } catch (IOException e) {
            // Just skip
        }

        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        mimeType = mimeTypesMap.getContentType(filePath);
        if (StringUtils.isNotBlank(mimeType)) {
            return mimeType;
        }

        return mimeType;
    }

    /**
     * Checks if the content type indicates text-based content
     * 
     * @param contentType the content type header value
     * @return true if the content is text-based, false otherwise
     */
    public static boolean isTextContentType(String contentType) {
        if (StringUtils.isBlank(contentType)) {
            return false;
        }
        
        String lowerContentType = contentType.toLowerCase();
        
        // Common text-based content types
        return lowerContentType.startsWith("text/") ||
               lowerContentType.equals("application/json") ||
               lowerContentType.equals("application/xml") ||
               lowerContentType.equals("application/javascript") ||
               lowerContentType.equals("application/xhtml+xml") ||
               lowerContentType.equals("application/atom+xml") ||
               lowerContentType.equals("application/rss+xml") ||
               lowerContentType.contains("+json") ||
               lowerContentType.contains("+xml") ||
               lowerContentType.contains("/javascript") ||
               lowerContentType.contains("/x-javascript") ||
               lowerContentType.contains("/x-www-form-urlencoded");
    }
}
