package com.kms.katalon.core.mobile.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;

public class FindElementsResult {

    private List<WebElement> elements;

    private String locator;

    private LocatorStrategy locatorStrategy;

    private String screenshot;

    public FindElementsResult(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy,
            String screenshot) {
        this.locatorStrategy = locatorStrategy;
        this.locator = locator;
        this.elements = elements;
        this.screenshot = screenshot;
    }

    public FindElementsResult(WebElement element, String locator, LocatorStrategy locatorStrategy, String screenshot) {
        this(new ArrayList<WebElement>(), locator, locatorStrategy, screenshot);
        if (element != null) {
            elements.add(element);
        }
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy,
            String screenshot) {
        return new FindElementsResult(elements, locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(List<WebElement> elements, String locator, LocatorStrategy locatorStrategy) {
        return new FindElementsResult(elements, locator, locatorStrategy, StringUtils.EMPTY);
    }

    public static FindElementsResult from(WebElement element, String locator, LocatorStrategy locatorStrategy,
            String screenshot) {
        return new FindElementsResult(element, locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(String locator, LocatorStrategy locatorStrategy, String screenshot) {
        return from(Collections.emptyList(), locator, locatorStrategy, screenshot);
    }

    public static FindElementsResult from(String locator, LocatorStrategy locatorStrategy) {
        return from(locator, locatorStrategy, StringUtils.EMPTY);
    }

    public static FindElementsResult from(LocatorStrategy locatorStrategy) {
        return from(StringUtils.EMPTY, locatorStrategy, StringUtils.EMPTY);
    }

    public static FindElementsResult from(List<WebElement> elements, TestObject healedTestObject) {
        MobileTestObject mobileTestObject = ((MobileTestObject) healedTestObject);
        LocatorStrategy locatorStrategy = mobileTestObject.getLocatorStrategy();
        String locator = mobileTestObject.getLocatorCollection().get(locatorStrategy);
        return from(elements, locator, locatorStrategy);
    }

    public LocatorStrategy getLocatorStrategy() {
        return locatorStrategy;
    }

    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public String getLocator() {
        return locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public String getScreenshot() {
        return screenshot;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public List<WebElement> getElements() {
        return elements;
    }

    public void setElements(List<WebElement> elements) {
        this.elements = elements;
    }

    public WebElement getElement() {
        return elements != null && elements.size() > 0 ? elements.get(0) : null;
    }

    public void setElement(WebElement element) {
        if (elements == null) {
            elements = new ArrayList<WebElement>();
        } else {
            elements.clear();
        }

        elements.add(element);
    }

    public boolean isEmpty() {
        return elements == null || elements.isEmpty();
    }
}
