package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat
import org.apache.commons.lang3.StringUtils
import org.openqa.selenium.remote.CapabilityType

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling
import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver

@Action(value = "getDeviceOS")
public class GetDeviceOSKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        return getDeviceOS(flowControl)
    }

    @CompileStatic
    public String getDeviceOS(FailureHandling flowControl) throws StepFailedException {
        return MobileKeywordMain.runKeyword({
            String osName = MobileDriverFactory.getDeviceOS()
            if (StringUtils.isEmpty(osName)) {
                AppiumDriver driver = MobileDriverFactory.getDriver();
                Object platformName = driver.getCapabilities().getCapability(CapabilityType.PLATFORM_NAME);
                if (platformName != null) {
                    osName = platformName.toString();
                }
            }

            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_DEVICE_OS_NAME, osName))
            return osName
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_CANNOT_GET_OS_NAME)
    }
}
