package com.kms.katalon.core.appium.constants;

public class XCUITestSettingConstants {

    /**
     * Comma-separated list of element attribute names to include in findElement response.
     * Default: Only element UUID is included.
     */
    public static final String ELEMENT_RESPONSE_ATTRIBUTES = "elementResponseAttributes";

    /**
     * Determines whether findElement responses are compact.
     * Must be false for ELEMENT_RESPONSE_ATTRIBUTES to apply.
     * Default: true
     */
    public static final String SHOULD_USE_COMPACT_RESPONSES = "shouldUseCompactResponses";

    /**
     * The quality of screenshots captured, represented as an integer percentage (1-100).
     */
    public static final String SCREENSHOT_QUALITY = "screenshotQuality";

    /**
     * Maximum frames per second for the MJPEG screenshots broadcaster.
     * Range: 1 to 60. Default: 10
     */
    public static final String MJPEG_SERVER_FRAMERATE = "mjpegServerFramerate";

    /**
     * Scaling factor for MJPEG screenshots, represented as a percentage.
     * Range: 1 to 100. Default: 100 (no scaling).
     */
    public static final String MJPEG_SCALING_FACTOR = "mjpegScalingFactor";

    /**
     * JPEG compression quality for MJPEG screenshots, as a percentage.
     * Range: 1 to 100. Default: 25
     */
    public static final String MJPEG_SERVER_SCREENSHOT_QUALITY = "mjpegServerScreenshotQuality";

    /**
     * Timeout in seconds for resolving an accessibility snapshot.
     * Default: 15 seconds.
     */
    public static final String CUSTOM_SNAPSHOT_TIMEOUT = "customSnapshotTimeout";

    /**
     * Timeout in seconds to wait until the app under test becomes idle.
     */
    public static final String WAIT_FOR_IDLE_TIMEOUT = "waitForIdleTimeout";

    /**
     * Time in seconds to wait for animations to complete after each automation action.
     * Default: 2 seconds.
     */
    public static final String ANIMATION_COOL_OFF_TIMEOUT = "animationCoolOffTimeout";

    /**
     * Maximum depth for traversing the elements source tree.
     * Default: 50
     */
    public static final String SNAPSHOT_MAX_DEPTH = "snapshotMaxDepth";

    /**
     * Improves performance of single element lookups if enabled.
     * Known issue: May affect nested element lookups.
     * Default: false
     */
    public static final String USE_FIRST_MATCH = "useFirstMatch";

    /**
     * Changes the 'Reduce Motion' accessibility preference.
     * Default: false
     */
    public static final String REDUCE_MOTION = "reduceMotion";

    /**
     * Hint for selecting the active application in split-screen environments.
     * Default: "auto"
     */
    public static final String DEFAULT_ACTIVE_APPLICATION = "defaultActiveApplication";

    /**
     * Coordinates for detecting the active app, in the format "x,y".
     */
    public static final String ACTIVE_APP_DETECTION_POINT = "activeAppDetectionPoint";

    /**
     * Includes non-modal elements in the response for iOS 13+.
     * Default: false
     */
    public static final String INCLUDE_NON_MODAL_ELEMENTS = "includeNonModalElements";

    /**
     * Custom selector for the accept button in alerts.
     */
    public static final String ACCEPT_ALERT_BUTTON_SELECTOR = "acceptAlertButtonSelector";

    /**
     * Custom selector for the dismiss button in alerts.
     */
    public static final String DISMISS_ALERT_BUTTON_SELECTOR = "dismissAlertButtonSelector";

    /**
     * Enforces the orientation of screenshots.
     * Values: "auto", "portrait", "portraitUpsideDown", "landscapeRight", "landscapeLeft".
     */
    public static final String SCREENSHOT_ORIENTATION = "screenshotOrientation";

    /**
     * Whether to look up elements by accessibility or index.
     * Default: false (by accessibility).
     */
    public static final String BOUND_ELEMENTS_BY_INDEX = "boundElementsByIndex";

    /**
     * Toggles auto-correction in the keyboard settings.
     * Default: false
     */
    public static final String KEYBOARD_AUTOCORRECTION = "keyboardAutocorrection";

    /**
     * Toggles predictive text in the keyboard settings.
     * Default: false
     */
    public static final String KEYBOARD_PREDICTION = "keyboardPrediction";

    /**
     * Enables native web tap gestures.
     */
    public static final String NATIVE_WEB_TAP = "nativeWebTap";

    /**
     * Enables strict native web tap gestures.
     */
    public static final String NATIVE_WEB_TAP_STRICT = "nativeWebTapStrict";

    /**
     * Adjusts tab bar visibility in native web taps for faster interactions.
     */
    public static final String NATIVE_WEB_TAP_TAB_BAR_VISIBILITY = "nativeWebTapTabBarVisibility";

    /**
     * Adjusts smart app banner visibility in native web taps.
     */
    public static final String NATIVE_WEB_TAP_SMART_APP_BANNER_VISIBILITY = "nativeWebTapSmartAppBannerVisibility";

    /**
     * Handles offset of Safari's tab bar in native web taps.
     * Values: "top", "bottom".
     */
    public static final String SAFARI_TAB_BAR_POSITION = "safariTabBarPosition";

    /**
     * Toggles whether to use JSON-based page source retrieval.
     */
    public static final String USE_JSON_SOURCE = "useJSONSource";

    /**
     * Excludes specific attributes from page source retrieval.
     */
    public static final String PAGE_SOURCE_EXCLUDED_ATTRIBUTES = "pageSourceExcludedAttributes";

    /**
     * Maximum typing frequency in keystrokes per second.
     * Default: 60
     */
    public static final String MAX_TYPING_FREQUENCY = "maxTypingFrequency";

    /**
     * Forces WebDriverAgent to detect system alerts when checking for active apps.
     * Default: false
     */
    public static final String RESPECT_SYSTEM_ALERTS = "respectSystemAlerts";

    /**
     * Defines logic for capturing screenshots in web contexts.
     * Values: "native", "page", "viewport". Default: "native"
     */
    public static final String WEB_SCREENSHOT_MODE = "webScreenshotMode";

    /**
     * Uses a faster method for clearing text fields.
     * Default: true
     */
    public static final String USE_CLEAR_TEXT_SHORTCUT = "useClearTextShortcut";

}
