package com.kms.katalon.core.windows.driver;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

import org.openqa.selenium.remote.DesiredCapabilities;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;

import io.appium.java_client.windows.WindowsDriver;

public class WindowsSession {
    public enum TargetAppType {
        // Interact with a specific app such as KS, Notepad, etc.
        SPECIFIC_APP,
        // User can interact/inspect the whole window desktop.
        // There can be multiple "windows" from multiple active apps in the element tree
        ROOT_APP
    }

    private WindowsDriver applicationDriver;

    private WindowsDriver desktopDriver;

    private TargetAppType targetAppType = TargetAppType.SPECIFIC_APP;

    private final URL remoteAddressURL;

    private final String appFile;

    private final DesiredCapabilities initCapabilities;

    private final ProxyInformation proxyInfo;

    private final String appTitle;

    private final StringMatchingStrategy appTitleMatchingStrategy;

    public WindowsSession(URL remoteAddressURL, String appFile, DesiredCapabilities initCapabilities,
            ProxyInformation proxyInfo, String appTitle, StringMatchingStrategy appTitleMatchingStrategy) {
        this.remoteAddressURL = remoteAddressURL;
        this.appFile = appFile;
        this.initCapabilities = initCapabilities;
        this.proxyInfo = proxyInfo;
        this.appTitle = appTitle;
        this.appTitleMatchingStrategy = appTitleMatchingStrategy;
    }

    public WindowsDriver getOrCreateDesktopDriver() throws IOException, URISyntaxException {
        if (desktopDriver == null) {
            desktopDriver = new WindowsDriver(WindowsDriverFactory.getAppiumExecutorForRemoteDriver(remoteAddressURL,
                    proxyInfo, initCapabilities), new WindowsDesiredCapsBuilder().withRootApp().build());
        }

        return desktopDriver;
    }

    public WindowsDriver getApplicationDriver() {
        return applicationDriver;
    }

    public void setApplicationDriver(WindowsDriver applicationDriver) {
        this.applicationDriver = applicationDriver;
    }

    public TargetAppType getTargetAppType() {
        return targetAppType;
    }

    public void setTargetAppType(TargetAppType targetAppType) {
        this.targetAppType = targetAppType;
    }

    public WindowsDriver getRunningDriver() {
        return TargetAppType.SPECIFIC_APP.equals(targetAppType) ? applicationDriver : desktopDriver;
    }

    public URL getRemoteAddressURL() {
        return remoteAddressURL;
    }

    public String getAppFile() {
        return appFile;
    }

    public DesiredCapabilities getInitCapabilities() {
        return initCapabilities;
    }

    public ProxyInformation getProxyInfo() {
        return proxyInfo;
    }

    public String getAppTitle() {
        return appTitle;
    }

    public StringMatchingStrategy getAppTitleMatchingStrategy() {
        return appTitleMatchingStrategy;
    }
}
