package com.kms.katalon.core.windows.keyword.builtin;

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.AbstractKeyword
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.WindowsTestObject
import com.kms.katalon.core.windows.driver.WindowsDriverFactory
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper

import io.appium.java_client.windows.WindowsDriver

@Action(value = "selectOptionByLabel")
public class SelectOptionByLabelKeyword extends AbstractKeyword {

    private int ARG_INDEX_TEST_OBJECT = 0;
    private int ARG_INDEX_LABEL = 1;
    private int ARG_INDEX_TIMEOUT = 2;
    private int ARG_INDEX_FLOW_CONTROL = 3;

    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return SupportLevel.NOT_SUPPORT;
    }

    @Override
    public Object execute(Object ...params) {
        WindowsTestObject testObject = (WindowsTestObject)getParam(params, ARG_INDEX_TEST_OBJECT);
        String labelText = (String) getParam(params, ARG_INDEX_LABEL);
        Integer timeoutInSeconds = (Integer) getParam(params, ARG_INDEX_TIMEOUT);
        FailureHandling flowControl = getFailureHandling(params, ARG_INDEX_FLOW_CONTROL);

        selectOptionByLabel(testObject, labelText, timeoutInSeconds, flowControl)
    }

    public void selectOptionByLabel(WindowsTestObject testObject, String labelText, Integer timeoutInSeconds, FailureHandling flowControl) throws StepFailedException {
        KeywordMain.runKeyword({
            WindowsDriver windowsDriver = WindowsDriverFactory.getWindowsDriver()
            if (windowsDriver == null) {
                KeywordMain.stepFailed("WindowsDriver has not started. Please try Windows.startApplication first.", flowControl)
            }

            int finalTimeoutInSeconds = WindowsActionHelper.checkTimeout(timeoutInSeconds)
            WindowsActionHelper
                    .create(WindowsDriverFactory.getWindowsSession())
                    .selectComboBoxItemByLabel(testObject, labelText, finalTimeoutInSeconds)

            logger.logPassed(String.format("Item labeled '%s' of object '%s' selected", labelText, testObject.getObjectId()))
        }, flowControl)
    }
}