package com.kms.katalon.core.webui.authentication.basic;

import java.net.URI;
import java.net.URL;
import java.util.function.Predicate;
import java.util.function.Supplier;

import org.openqa.selenium.Credentials;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;

import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.util.UrlUtil;

public class CdpBasicAuth implements BasicAuthenticationStrategy {

    @Override
    public boolean navigate(URL url, String username, String password, int timeout) {
        WebDriver driver = DriverFactory.getWebDriver();
        Predicate<URI> uriPredicate = (URI uri) -> uri.toString().contains(url.getHost());
        Supplier<Credentials> authentication = UsernameAndPassword.of(username, password);
        ((HasAuthentication) driver).register(uriPredicate, authentication);
    
        driver.navigate().to(url.toString());
        return UrlUtil.assertUrlsWithoutProtocol(url.toString(), driver.getCurrentUrl());
    }
}
