package com.kms.katalon.core.webui.common.controller;

import java.util.LinkedHashMap;

import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;

import com.kms.katalon.core.webui.model.ElementWaitingInteractableState;

public class WaitForPageRerender extends ElementWaitingPhase {

    public WaitForPageRerender(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        return """
                const notifyWaitingResult = arguments[arguments.length - 1];
                const timeout = arguments[0];

                const ElementWaitingInteractableState = {
                    DONE: 'DONE',
                    ELEMENT_DETACHED: 'ELEMENT_DETACHED',
                    TIMED_OUT: 'TIMED_OUT',
                    ERROR: 'ERROR',
                };

                function notifyWaitingError(error) {
                    notifyWaitingResult({ result: ElementWaitingInteractableState.ERROR, error: error.message });
                }

                // Wait for detached
                waitWithDOMMutation(() => {
                    return true;
                }, timeout).then((isDetached) => {
                    notifyWaitingResult({ result: isDetached
                        ? ElementWaitingInteractableState.DONE
                        : ElementWaitingInteractableState.TIMED_OUT });
                }).catch(notifyWaitingError);
                """;
    }

    /**
     * @param timeoutInMillis
     * @throws IllegalStateException if the element is not found in the DOM or the element was removed from the DOM
     * before the waiting script completed
     */
    public boolean run(long timeoutInMillis) {
        if (timeoutInMillis <= 0) {
            throw new IllegalArgumentException("Timeout must be greater than 0 milliseconds.");
        }
        if (executor == null) {
            throw new IllegalStateException("JavascriptExecutor is not found.");
        }
        String runningScript = getWaitingScript();
        try {
            Object result = ((JavascriptExecutor) this.executor).executeAsyncScript(runningScript,
                    timeoutInMillis);
            if (result instanceof LinkedHashMap resultMap && resultMap.containsKey("result")) {
                switch (ElementWaitingInteractableState.valueOf(resultMap.get("result").toString())) {
                    case DONE:
                        return true;
                    case TIMED_OUT:
                        throw new IllegalStateException("Waiting for page rerender timed out");
                    case ERROR:
                        throw new IllegalStateException("Error during waiting for page rerender: " + resultMap.get("error"));
                    default:
                        return false;
                }
            }
            return false;
        } catch (JavascriptException e) {
            throw new IllegalStateException("Error executing waiting script: " + e.getMessage(), e);
        }
    }
}
