/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.OfflinePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.models.ResolutionException;
import com.kms.katalon.activation.plugin.models.ResolutionItem;
import com.kms.katalon.activation.plugin.service.LocalRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PluginResolver {
    private static PluginResolver instance;

    private PluginResolver() {
    }

    public static PluginResolver getInstance() {
        if (instance == null) {
            instance = new PluginResolver();
        }
        return instance;
    }

    public List<ResolutionItem> resolveOnlinePlugins(List<KStorePlugin> onlinePlugins, KStoreCredentials credentials, IProgressMonitor monitor) throws ResolutionException {
        return LocalRepository.getInstance().resolvePlugins(onlinePlugins, credentials, monitor);
    }

    public List<ResolutionItem> resolveExpiredTrialPlugins(List<KStorePlugin> expiredTrialPlugins, IProgressMonitor monitor) {
        return LocalRepository.getInstance().resolveExpiredTrialPlugins(expiredTrialPlugins, monitor);
    }

    public List<ResolutionItem> resolveOfflinePlugins(List<OfflinePlugin> offlinePlugins, IProgressMonitor progressMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.beginTask("", 100);
        ArrayList<ResolutionItem> resolutionItems = new ArrayList<ResolutionItem>();
        int totalWork = offlinePlugins.size();
        int progress = 0;
        for (OfflinePlugin plugin : offlinePlugins) {
            if (plugin.getName().contains("katalon-studio-basic-report-plugin")) continue;
            Plugin resolvedPlugin = new Plugin();
            resolvedPlugin.setName(plugin.getName());
            resolvedPlugin.setFile(plugin.getFile());
            resolvedPlugin.setCustomKeywordPlugin(plugin.isCustomKeywordPlugin());
            ResolutionItem resolutionItem = new ResolutionItem();
            resolutionItem.setPlugin(resolvedPlugin);
            resolutionItems.add(resolutionItem);
            int subWork = Math.round((float)(++progress) * 100.0f / (float)totalWork);
            monitor.worked(subWork);
        }
        return resolutionItems;
    }
}

