/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
@FunctionalInterface
public interface CacheLoader<K, V>
extends AsyncCacheLoader<K, V> {
    public V load(K var1) throws Exception;

    default public Map<? extends K, ? extends @NonNull V> loadAll(Set<? extends K> keys2) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    default public CompletableFuture<? extends V> asyncLoad(K key, Executor executor) throws Exception {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.load(key);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    @Override
    default public CompletableFuture<? extends Map<? extends K, ? extends @NonNull V>> asyncLoadAll(Set<? extends K> keys2, Executor executor) throws Exception {
        Objects.requireNonNull(keys2);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadAll(keys2);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    default public V reload(K key, @NonNull V oldValue) throws Exception {
        return this.load(key);
    }

    @Override
    default public CompletableFuture<? extends V> asyncReload(K key, @NonNull V oldValue, Executor executor) throws Exception {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.reload(key, oldValue);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    public static <K, V> CacheLoader<K, V> bulk(final Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends @NonNull V>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return new CacheLoader<K, V>(){

            @Override
            public V load(K key) {
                return this.loadAll(Set.of(key)).get(key);
            }

            @Override
            public Map<? extends K, ? extends @NonNull V> loadAll(Set<? extends K> keys2) {
                return (Map)mappingFunction.apply(keys2);
            }
        };
    }
}

