/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

@PublicApi
public class DataFetcherResult<T> {
    private final T data;
    private final List<GraphQLError> errors;
    private final Object localContext;
    private final Map<Object, Object> extensions;

    private DataFetcherResult(T data, List<GraphQLError> errors2, Object localContext, Map<Object, Object> extensions) {
        this.data = data;
        this.errors = ImmutableList.copyOf((Collection)Assert.assertNotNull(errors2));
        this.localContext = localContext;
        this.extensions = extensions;
    }

    public T getData() {
        return this.data;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    public DataFetcherResult<T> transform(Consumer<Builder<T>> builderConsumer) {
        Builder<DataFetcherResult> builder = new Builder<DataFetcherResult>(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public <R> DataFetcherResult<R> map(Function<T, R> transformation) {
        return new Builder<R>(transformation.apply(this.data)).errors(this.errors).extensions(this.extensions).localContext(this.localContext).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFetcherResult that = (DataFetcherResult)o;
        return Objects.equals(this.data, that.data) && this.errors.equals(that.errors) && Objects.equals(this.localContext, that.localContext) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.localContext, this.extensions);
    }

    public String toString() {
        return "DataFetcherResult{data=" + String.valueOf(this.data) + ", errors=" + String.valueOf(this.errors) + ", localContext=" + String.valueOf(this.localContext) + ", extensions=" + String.valueOf(this.extensions) + "}";
    }

    public static <T> Builder<T> newResult() {
        return new Builder();
    }

    public static class Builder<T> {
        private T data;
        private Object localContext;
        private final List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private Map<Object, Object> extensions;

        public Builder(DataFetcherResult<T> existing) {
            this.data = existing.getData();
            this.localContext = existing.getLocalContext();
            this.errors.addAll(existing.getErrors());
            this.extensions = existing.extensions;
        }

        public Builder(T data) {
            this.data = data;
        }

        public Builder() {
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(List<GraphQLError> errors2) {
            this.errors.addAll(errors2);
            return this;
        }

        public Builder<T> error(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder<T> clearErrors() {
            this.errors.clear();
            return this;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public Builder<T> localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public Builder<T> extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public DataFetcherResult<T> build() {
            return new DataFetcherResult<T>(this.data, this.errors, this.localContext, this.extensions);
        }
    }
}

