/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.DuckTyped;
import graphql.EngineRunningState;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TrivialDataFetcher;
import graphql.TypeMismatchError;
import graphql.UnresolvedTypeError;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.Maps;
import graphql.execution.AbortExecutionException;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResolveType;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.incremental.DeferredExecutionSupport;
import graphql.execution.instrumentation.ExecuteObjectInstrumentationContext;
import graphql.execution.instrumentation.FieldFetchingInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.reactive.ReactiveSupport;
import graphql.extensions.ExtensionsBuilder;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.LightDataFetcher;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

@PublicSpi
public abstract class ExecutionStrategy {
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;
    private final ResolveType resolvedType = new ResolveType();

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    @Internal
    public static String mkNameForPath(Field currentField) {
        return ExecutionStrategy.mkNameForPath(Collections.singletonList(currentField));
    }

    @Internal
    public static String mkNameForPath(MergedField mergedField) {
        return ExecutionStrategy.mkNameForPath(mergedField.getFields());
    }

    @Internal
    public static String mkNameForPath(List<Field> currentField) {
        Field field = currentField.get(0);
        return field.getResultKey();
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    @DuckTyped(shape="CompletableFuture<Map<String, Object>> | Map<String, Object>")
    protected Object executeObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        DataLoaderDispatchStrategy dataLoaderDispatcherStrategy = executionContext.getDataLoaderDispatcherStrategy();
        dataLoaderDispatcherStrategy.executeObject(executionContext, parameters);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecuteObjectInstrumentationContext resolveObjectCtx = ExecuteObjectInstrumentationContext.nonNullCtx(instrumentation.beginExecuteObject(instrumentationParameters, executionContext.getInstrumentationState()));
        List<String> fieldNames = parameters.getFields().getKeys();
        DeferredExecutionSupport deferredExecutionSupport = this.createDeferredExecutionSupport(executionContext, parameters);
        Async.CombinedBuilder<FieldValueInfo> resolvedFieldFutures = this.getAsyncFieldValueInfo(executionContext, parameters, deferredExecutionSupport);
        CompletableFuture<Map<String, Object>> overallResult = new CompletableFuture<Map<String, Object>>();
        List<String> fieldsExecutedOnInitialResult = deferredExecutionSupport.getNonDeferredFieldNames(fieldNames);
        BiConsumer<List<Object>, Throwable> handleResultsConsumer = this.buildFieldValueMap(fieldsExecutedOnInitialResult, overallResult, executionContext);
        resolveObjectCtx.onDispatched();
        Object fieldValueInfosResult = resolvedFieldFutures.awaitPolymorphic();
        if (fieldValueInfosResult instanceof CompletableFuture) {
            CompletableFuture fieldValueInfos = (CompletableFuture)fieldValueInfosResult;
            ((CompletableFuture)fieldValueInfos.whenComplete((completeValueInfos, throwable) -> {
                if (throwable != null) {
                    handleResultsConsumer.accept((List<Object>)null, (Throwable)throwable);
                    return;
                }
                Async.CombinedBuilder<Object> resultFutures = ExecutionStrategy.fieldValuesCombinedBuilder(completeValueInfos);
                dataLoaderDispatcherStrategy.executeObjectOnFieldValuesInfo((List<FieldValueInfo>)completeValueInfos, parameters);
                resolveObjectCtx.onFieldValuesInfo((List<FieldValueInfo>)completeValueInfos);
                resultFutures.await().whenComplete((BiConsumer)handleResultsConsumer);
            })).exceptionally(ex -> {
                dataLoaderDispatcherStrategy.executeObjectOnFieldValuesException((Throwable)ex, parameters);
                resolveObjectCtx.onFieldValuesException();
                overallResult.completeExceptionally((Throwable)ex);
                return null;
            });
            overallResult.whenComplete(resolveObjectCtx::onCompleted);
            return overallResult;
        }
        List completeValueInfos2 = (List)fieldValueInfosResult;
        Async.CombinedBuilder<Object> resultFutures = ExecutionStrategy.fieldValuesCombinedBuilder(completeValueInfos2);
        dataLoaderDispatcherStrategy.executeObjectOnFieldValuesInfo(completeValueInfos2, parameters);
        resolveObjectCtx.onFieldValuesInfo(completeValueInfos2);
        Object completedValuesObject = resultFutures.awaitPolymorphic();
        if (completedValuesObject instanceof CompletableFuture) {
            CompletableFuture completedValues = (CompletableFuture)completedValuesObject;
            completedValues.whenComplete(handleResultsConsumer);
            overallResult.whenComplete(resolveObjectCtx::onCompleted);
            return overallResult;
        }
        Map<String, Object> fieldValueMap = ExecutionStrategy.buildFieldValueMap(fieldsExecutedOnInitialResult, (List)completedValuesObject);
        resolveObjectCtx.onCompleted(fieldValueMap, null);
        return fieldValueMap;
    }

    private static @NonNull Async.CombinedBuilder<Object> fieldValuesCombinedBuilder(List<FieldValueInfo> completeValueInfos) {
        Async.CombinedBuilder<Object> resultFutures = Async.ofExpectedSize(completeValueInfos.size());
        for (FieldValueInfo completeValueInfo : completeValueInfos) {
            resultFutures.addObject(completeValueInfo.getFieldValueObject());
        }
        return resultFutures;
    }

    private BiConsumer<List<Object>, Throwable> buildFieldValueMap(List<String> fieldNames, CompletableFuture<Map<String, Object>> overallResult, ExecutionContext executionContext) {
        return (results, exception) -> {
            if (exception != null) {
                this.handleValueException(overallResult, (Throwable)exception, executionContext);
                return;
            }
            Map<String, Object> resolvedValuesByField = ExecutionStrategy.buildFieldValueMap(fieldNames, results);
            overallResult.complete(resolvedValuesByField);
        };
    }

    private static @NonNull Map<String, Object> buildFieldValueMap(List<String> fieldNames, List<Object> results) {
        LinkedHashMap<String, Object> resolvedValuesByField = Maps.newLinkedHashMapWithExpectedSize(fieldNames.size());
        int ix = 0;
        for (Object fieldValue : results) {
            String fieldName = fieldNames.get(ix++);
            resolvedValuesByField.put(fieldName, fieldValue);
        }
        return resolvedValuesByField;
    }

    DeferredExecutionSupport createDeferredExecutionSupport(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        MergedSelectionSet fields = parameters.getFields();
        return executionContext.hasIncrementalSupport() ? new DeferredExecutionSupport.DeferredExecutionSupportImpl(fields, parameters, executionContext, (ec, esp) -> Async.toCompletableFuture(this.resolveFieldWithInfo((ExecutionContext)ec, (ExecutionStrategyParameters)esp))) : DeferredExecutionSupport.NOOP;
    }

    @NonNull Async.CombinedBuilder<FieldValueInfo> getAsyncFieldValueInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, DeferredExecutionSupport deferredExecutionSupport) {
        MergedSelectionSet fields = parameters.getFields();
        executionContext.getIncrementalCallState().enqueue(deferredExecutionSupport.createCalls(parameters));
        Async.CombinedBuilder<FieldValueInfo> futures = Async.ofExpectedSize(fields.size() - deferredExecutionSupport.deferredFieldsCount());
        for (String fieldName : fields.getKeys()) {
            MergedField currentField = fields.getSubField(fieldName);
            ResultPath fieldPath = parameters.getPath().segment(ExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(currentField, fieldPath, parameters);
            if (deferredExecutionSupport.isDeferredField(currentField)) continue;
            Object fieldValueInfo = this.resolveFieldWithInfo(executionContext, newParameters);
            futures.addObject(fieldValueInfo);
        }
        return futures;
    }

    @DuckTyped(shape="CompletableFuture<FieldValueInfo> | FieldValueInfo")
    protected Object resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().getSingleField());
        Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, null));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<Object> fieldCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldExecution(new InstrumentationFieldParameters(executionContext, executionStepInfo), executionContext.getInstrumentationState()));
        Object fetchedValueObj = this.fetchField(executionContext, parameters);
        if (fetchedValueObj instanceof CompletableFuture) {
            CompletableFuture fetchFieldFuture = (CompletableFuture)fetchedValueObj;
            CompletionStage result = fetchFieldFuture.thenApply(fetchedValue -> this.completeField(fieldDef, executionContext, parameters, (FetchedValue)fetchedValue));
            fieldCtx.onDispatched();
            ((CompletableFuture)result).whenComplete(fieldCtx::onCompleted);
            return result;
        }
        try {
            FetchedValue fetchedValue2 = (FetchedValue)fetchedValueObj;
            FieldValueInfo fieldValueInfo = this.completeField(fieldDef, executionContext, parameters, fetchedValue2);
            fieldCtx.onDispatched();
            fieldCtx.onCompleted(fetchedValue2.getFetchedValue(), null);
            return fieldValueInfo;
        }
        catch (Exception e) {
            return Async.exceptionallyCompletedFuture(e);
        }
    }

    @DuckTyped(shape="CompletableFuture<FetchedValue> | FetchedValue")
    protected Object fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        MergedField field = parameters.getField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field.getSingleField());
        return this.fetchField(fieldDef, executionContext, parameters);
    }

    @DuckTyped(shape="CompletableFuture<FetchedValue> | FetchedValue")
    private Object fetchField(GraphQLFieldDefinition fieldDef, ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        if (this.incrementAndCheckMaxNodesExceeded(executionContext)) {
            return new FetchedValue(null, Collections.emptyList(), null);
        }
        MergedField field = parameters.getField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        Supplier<DataFetchingEnvironment> dataFetchingEnvironment = FpKit.intraThreadMemoize(() -> {
            Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType));
            Supplier<Map<String, Object>> argumentValues = () -> ((ExecutionStepInfo)executionStepInfo.get()).getArguments();
            Supplier<ExecutableNormalizedField> normalizedFieldSupplier = this.getNormalizedField(executionContext, parameters, executionStepInfo);
            DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext.getGraphQLSchema(), fieldDef.getType(), normalizedFieldSupplier);
            QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(field, executionContext.getGraphQLSchema(), executionContext.getCoercedVariables(), executionContext.getNormalizedVariables(), executionContext.getGraphQLContext(), executionContext.getLocale());
            return DataFetchingEnvironmentImpl.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).localContext(parameters.getLocalContext()).arguments(argumentValues).fieldDefinition(fieldDef).mergedField(parameters.getField()).fieldType(fieldDef.getType()).executionStepInfo(executionStepInfo).parentType(parentType).selectionSet(fieldCollector).queryDirectives(queryDirectives).build();
        });
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        DataFetcher<?> dataFetcher = codeRegistry.getDataFetcher(parentType, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, dataFetchingEnvironment, parameters, dataFetcher instanceof TrivialDataFetcher);
        FieldFetchingInstrumentationContext fetchCtx = FieldFetchingInstrumentationContext.nonNullCtx(instrumentation.beginFieldFetching(instrumentationFieldFetchParams, executionContext.getInstrumentationState()));
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams, executionContext.getInstrumentationState());
        dataFetcher = executionContext.getDataLoaderDispatcherStrategy().modifyDataFetcher(dataFetcher);
        Object fetchedObject = this.invokeDataFetcher(executionContext, parameters, fieldDef, dataFetchingEnvironment, dataFetcher);
        executionContext.getDataLoaderDispatcherStrategy().fieldFetched(executionContext, parameters, dataFetcher, fetchedObject);
        fetchCtx.onDispatched();
        fetchCtx.onFetchedValue(fetchedObject);
        if (!executionContext.isSubscriptionOperation()) {
            fetchedObject = ReactiveSupport.fetchedObject(fetchedObject);
        }
        if (fetchedObject instanceof CompletableFuture) {
            CompletableFuture fetchedValue = (CompletableFuture)fetchedObject;
            EngineRunningState engineRunningState = executionContext.getEngineRunningState();
            CompletableFuture<CompletableFuture> handleCF = engineRunningState.handle(fetchedValue, (result, exception) -> {
                fetchCtx.onCompleted(result, (Throwable)exception);
                if (exception != null) {
                    CompletableFuture handleFetchingExceptionResult = this.handleFetchingException((DataFetchingEnvironment)dataFetchingEnvironment.get(), parameters, (Throwable)exception);
                    return handleFetchingExceptionResult;
                }
                return fetchedValue;
            });
            CompletableFuture rawResultCF = engineRunningState.compose(handleCF, Function.identity());
            CompletionStage fetchedValueCF = rawResultCF.thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result));
            return fetchedValueCF;
        }
        fetchCtx.onCompleted(fetchedObject, null);
        return this.unboxPossibleDataFetcherResult(executionContext, parameters, fetchedObject);
    }

    private Object invokeDataFetcher(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDef, Supplier<DataFetchingEnvironment> dataFetchingEnvironment, DataFetcher<?> dataFetcher) {
        Object fetchedValue;
        try {
            Object fetchedValueRaw = dataFetcher instanceof LightDataFetcher ? ((LightDataFetcher)dataFetcher).get(fieldDef, parameters.getSource(), dataFetchingEnvironment) : dataFetcher.get(dataFetchingEnvironment.get());
            fetchedValue = Async.toCompletableFutureOrMaterializedObject(fetchedValueRaw);
        }
        catch (Exception e) {
            fetchedValue = Async.exceptionallyCompletedFuture(e);
        }
        return fetchedValue;
    }

    protected Supplier<ExecutableNormalizedField> getNormalizedField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Supplier<ExecutionStepInfo> executionStepInfo) {
        Supplier<ExecutableNormalizedOperation> normalizedQuery = executionContext.getNormalizedQueryTree();
        return () -> ((ExecutableNormalizedOperation)normalizedQuery.get()).getNormalizedField(parameters.getField(), ((ExecutionStepInfo)executionStepInfo.get()).getObjectType(), ((ExecutionStepInfo)executionStepInfo.get()).getPath());
    }

    protected FetchedValue unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            ExecutionStrategy.addErrorsToRightContext(dataFetcherResult.getErrors(), parameters, executionContext);
            this.addExtensionsIfPresent(executionContext, dataFetcherResult);
            Object localContext = dataFetcherResult.getLocalContext();
            if (localContext == null) {
                localContext = parameters.getLocalContext();
            }
            Object unBoxedValue = executionContext.getValueUnboxer().unbox(dataFetcherResult.getData());
            return new FetchedValue(unBoxedValue, dataFetcherResult.getErrors(), localContext);
        }
        Object unBoxedValue = executionContext.getValueUnboxer().unbox(result);
        return new FetchedValue(unBoxedValue, ImmutableList.of(), parameters.getLocalContext());
    }

    private void addExtensionsIfPresent(ExecutionContext executionContext, DataFetcherResult<?> dataFetcherResult) {
        ExtensionsBuilder extensionsBuilder;
        Map<Object, Object> extensions = dataFetcherResult.getExtensions();
        if (extensions != null && (extensionsBuilder = (ExtensionsBuilder)executionContext.getGraphQLContext().get(ExtensionsBuilder.class)) != null) {
            extensionsBuilder.addValues(extensions);
        }
    }

    protected <T> CompletableFuture<T> handleFetchingException(DataFetchingEnvironment environment, ExecutionStrategyParameters parameters, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(e).build();
        try {
            return this.asyncHandleException(this.dataFetcherExceptionHandler, handlerParameters);
        }
        catch (Exception handlerException) {
            handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(handlerException).build();
            return this.asyncHandleException(new SimpleDataFetcherExceptionHandler(), handlerParameters);
        }
    }

    private <T> CompletableFuture<T> asyncHandleException(DataFetcherExceptionHandler handler, DataFetcherExceptionHandlerParameters handlerParameters) {
        return handler.handleException(handlerParameters).thenApply(handlerResult -> DataFetcherResult.newResult().errors(handlerResult.getErrors()).build());
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        Field field = parameters.getField().getSingleField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        return this.completeField(fieldDef, executionContext, parameters, fetchedValue);
    }

    private FieldValueInfo completeField(GraphQLFieldDefinition fieldDef, ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, fetchedValue);
        InstrumentationContext<Object> ctxCompleteField = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldCompletion(instrumentationParams, executionContext.getInstrumentationState()));
        ExecutionStrategyParameters newParameters = parameters.transform(executionStepInfo, fetchedValue.getLocalContext(), fetchedValue.getFetchedValue());
        FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
        ctxCompleteField.onDispatched();
        if (fieldValueInfo.isFutureValue()) {
            CompletableFuture<Object> executionResultFuture = fieldValueInfo.getFieldValueFuture();
            executionResultFuture.whenComplete(ctxCompleteField::onCompleted);
        } else {
            ctxCompleteField.onCompleted(fieldValueInfo.getFieldValueObject(), null);
        }
        return fieldValueInfo;
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Object fieldValue;
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Object result = executionContext.getValueUnboxer().unbox(parameters.getSource());
        GraphQLOutputType fieldType = executionStepInfo.getUnwrappedNonNullType();
        if (result == null) {
            return this.getFieldValueInfoForNull(parameters);
        }
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (GraphQLTypeUtil.isScalar(fieldType)) {
            Object fieldValue2 = this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
            return new FieldValueInfo(FieldValueInfo.CompleteValueType.SCALAR, fieldValue2);
        }
        if (GraphQLTypeUtil.isEnum(fieldType)) {
            Object fieldValue3 = this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
            return new FieldValueInfo(FieldValueInfo.CompleteValueType.ENUM, fieldValue3);
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
            fieldValue = this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
        }
        catch (UnresolvedTypeException ex) {
            this.handleUnresolvedTypeProblem(executionContext, parameters, ex);
            return this.getFieldValueInfoForNull(parameters);
        }
        return new FieldValueInfo(FieldValueInfo.CompleteValueType.OBJECT, fieldValue);
    }

    private void handleUnresolvedTypeProblem(ExecutionContext context, ExecutionStrategyParameters parameters, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(parameters.getPath(), parameters.getExecutionStepInfo(), e);
        ExecutionStrategy.addErrorToRightContext(error, parameters, context);
    }

    private FieldValueInfo getFieldValueInfoForNull(ExecutionStrategyParameters parameters) {
        Object fieldValue = this.completeValueForNull(parameters);
        return new FieldValueInfo(FieldValueInfo.CompleteValueType.NULL, fieldValue);
    }

    @DuckTyped(shape="CompletableFuture<Object> | Object")
    protected Object completeValueForNull(ExecutionStrategyParameters parameters) {
        try {
            return parameters.getNonNullFieldValidator().validate(parameters, null);
        }
        catch (Exception e) {
            return Async.exceptionallyCompletedFuture(e);
        }
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        try {
            resultIterable = parameters.getNonNullFieldValidator().validate(parameters, resultIterable);
        }
        catch (NonNullableFieldWasNullException e) {
            return new FieldValueInfo(FieldValueInfo.CompleteValueType.LIST, Async.exceptionallyCompletedFuture(e));
        }
        if (resultIterable == null) {
            return new FieldValueInfo(FieldValueInfo.CompleteValueType.LIST, null);
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        CompletableFuture listOrPromiseToList;
        OptionalInt size = FpKit.toSize(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, iterableValues);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<Object> completeListCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginFieldListCompletion(instrumentationParams, executionContext.getInstrumentationState()));
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>(size.orElse(1));
        int index = 0;
        for (Object item : iterableValues) {
            if (this.incrementAndCheckMaxNodesExceeded(executionContext)) {
                return new FieldValueInfo(FieldValueInfo.CompleteValueType.NULL, null, fieldValueInfos);
            }
            ResultPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo stepInfoForListElement = this.executionStepInfoFactory.newExecutionStepInfoForListElement(executionStepInfo, indexedPath);
            FetchedValue value = this.unboxPossibleDataFetcherResult(executionContext, parameters, item);
            ExecutionStrategyParameters newParameters = parameters.transform(stepInfoForListElement, indexedPath, value.getLocalContext(), value.getFetchedValue());
            fieldValueInfos.add(this.completeValue(executionContext, newParameters));
            ++index;
        }
        CompletableFuture listResults = Async.eachPolymorphic(fieldValueInfos, FieldValueInfo::getFieldValueObject);
        if (listResults instanceof CompletableFuture) {
            CompletableFuture resultsFuture = listResults;
            CompletableFuture overallResult = new CompletableFuture();
            completeListCtx.onDispatched();
            overallResult.whenComplete(completeListCtx::onCompleted);
            resultsFuture.whenComplete((results, exception) -> {
                if (exception != null) {
                    this.handleValueException(overallResult, (Throwable)exception, executionContext);
                    return;
                }
                ArrayList completedResults = new ArrayList(results.size());
                completedResults.addAll(results);
                overallResult.complete(completedResults);
            });
            listOrPromiseToList = overallResult;
        } else {
            completeListCtx.onCompleted(listResults, null);
            listOrPromiseToList = listResults;
        }
        return new FieldValueInfo(FieldValueInfo.CompleteValueType.LIST, listOrPromiseToList, fieldValueInfos);
    }

    protected <T> void handleValueException(CompletableFuture<T> overallResult, Throwable e, ExecutionContext executionContext) {
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, overallResult);
            if (!overallResult.isDone()) {
                overallResult.complete(null);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionContext.addError(abortException);
            if (!overallResult.isDone()) {
                overallResult.complete(null);
            }
        } else {
            overallResult.completeExceptionally(e);
        }
    }

    @DuckTyped(shape="CompletableFuture<Object> | Object")
    protected Object completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result, executionContext.getGraphQLContext(), executionContext.getLocale());
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters, serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return serialized;
    }

    @DuckTyped(shape="CompletableFuture<Object> | Object")
    protected Object completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.serialize(result, executionContext.getGraphQLContext(), executionContext.getLocale());
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters, serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return serialized;
    }

    @DuckTyped(shape="CompletableFuture<Map<String, Object>> | Map<String, Object>")
    protected Object completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getCoercedVariables().toMap()).graphQLContext(executionContext.getGraphQLContext()).build();
        MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField(), executionContext.hasIncrementalSupport());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        ExecutionStrategyParameters newParameters = parameters.transform(newExecutionStepInfo, subFields, result);
        return executionContext.getQueryStrategy().executeObject(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        ExecutionStrategy.addErrorToRightContext(error, parameters, context);
        return null;
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        if (fieldType instanceof GraphQLObjectType) {
            return (GraphQLObjectType)fieldType;
        }
        return this.resolvedType.resolveType(executionContext, parameters.getField(), parameters.getSource(), parameters.getExecutionStepInfo(), fieldType, parameters.getLocalContext());
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (FpKit.isIterable(result)) {
            return FpKit.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getExecutionStepInfo().getUnwrappedNonNullType());
        ExecutionStrategy.addErrorToRightContext(error, parameters, context);
    }

    private boolean incrementAndCheckMaxNodesExceeded(ExecutionContext executionContext) {
        int resultNodesCount = executionContext.getResultNodesInfo().incrementAndGetResultNodesCount();
        Integer maxNodes = (Integer)executionContext.getGraphQLContext().get("__MAX_RESULT_NODES");
        if (maxNodes != null && resultNodesCount > maxNodes) {
            executionContext.getResultNodesInfo().maxResultNodesExceeded();
            return true;
        }
        return false;
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDefinition(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResult executionResult = null;
        ImmutableList<GraphQLError> errors2 = ImmutableList.copyOf(executionContext.getErrors());
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, errors2);
                result.complete(executionResult);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionResult = abortException.toExecutionResult();
            result.complete(executionResult);
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition, GraphQLObjectType fieldContainer) {
        return this.executionStepInfoFactory.createExecutionStepInfo(executionContext, parameters, fieldDefinition, fieldContainer);
    }

    private static void addErrorToRightContext(GraphQLError error, ExecutionStrategyParameters parameters, ExecutionContext executionContext) {
        if (parameters.getDeferredCallContext() != null) {
            parameters.getDeferredCallContext().addError(error);
        } else {
            executionContext.addError(error);
        }
    }

    private static void addErrorsToRightContext(List<GraphQLError> errors2, ExecutionStrategyParameters parameters, ExecutionContext executionContext) {
        if (parameters.getDeferredCallContext() != null) {
            parameters.getDeferredCallContext().addErrors(errors2);
        } else {
            executionContext.addErrors(errors2);
        }
    }
}

