/*
 * Decompiled with CFR 0.152.
 */
package graphql.incremental;

import graphql.ExecutionResult;
import graphql.ExperimentalApi;
import graphql.GraphQLError;
import graphql.incremental.IncrementalPayload;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@ExperimentalApi
public class DeferPayload
extends IncrementalPayload {
    private final Object data;

    private DeferPayload(Object data, List<Object> path, String label, List<GraphQLError> errors2, Map<Object, Object> extensions) {
        super(path, label, errors2, extensions);
        this.data = data;
    }

    public <T> @Nullable T getData() {
        return (T)this.data;
    }

    @Override
    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(super.toSpecification());
        map.put("data", this.data);
        return map;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DeferPayload that = (DeferPayload)obj;
        return Objects.equals(this.data, that.data);
    }

    public static Builder newDeferredItem() {
        return new Builder();
    }

    public static class Builder
    extends IncrementalPayload.Builder<Builder> {
        private Object data = null;

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder from(DeferPayload deferredItem) {
            super.from(deferredItem);
            this.data = deferredItem.data;
            return this;
        }

        public Builder from(ExecutionResult executionResult) {
            this.data = executionResult.getData();
            this.errors = executionResult.getErrors();
            this.extensions = executionResult.getExtensions();
            return this;
        }

        public DeferPayload build() {
            return new DeferPayload(this.data, this.path, this.label, this.errors, this.extensions);
        }
    }
}

