/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.ExecutionContext;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.ValuesResolver;
import graphql.introspection.GoodFaithIntrospection;
import graphql.introspection.IntrospectionDataFetcher;
import graphql.introspection.IntrospectionDataFetchingEnvironment;
import graphql.introspection.IntrospectionDisabledError;
import graphql.language.AstPrinter;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.InputValueWithState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

@PublicApi
public class Introspection {
    public static final String INTROSPECTION_DISABLED = "INTROSPECTION_DISABLED";
    private static final AtomicBoolean INTROSPECTION_ENABLED_STATE = new AtomicBoolean(true);
    private static final Map<FieldCoordinates, IntrospectionDataFetcher<?>> introspectionDataFetchers = new LinkedHashMap();
    public static final GraphQLEnumType __TypeKind = GraphQLEnumType.newEnum().name("__TypeKind").description("An enum describing what kind of type a given __Type is").value("SCALAR", (Object)TypeKind.SCALAR, "Indicates this type is a scalar. 'specifiedByURL' is a valid field").value("OBJECT", (Object)TypeKind.OBJECT, "Indicates this type is an object. `fields` and `interfaces` are valid fields.").value("INTERFACE", (Object)TypeKind.INTERFACE, "Indicates this type is an interface. `fields` and `possibleTypes` are valid fields.").value("UNION", (Object)TypeKind.UNION, "Indicates this type is a union. `possibleTypes` is a valid field.").value("ENUM", (Object)TypeKind.ENUM, "Indicates this type is an enum. `enumValues` is a valid field.").value("INPUT_OBJECT", (Object)TypeKind.INPUT_OBJECT, "Indicates this type is an input object. `inputFields` is a valid field.").value("LIST", (Object)TypeKind.LIST, "Indicates this type is a list. `ofType` is a valid field.").value("NON_NULL", (Object)TypeKind.NON_NULL, "Indicates this type is a non-null. `ofType` is a valid field.").build();
    private static final IntrospectionDataFetcher<?> kindDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLScalarType) {
            return TypeKind.SCALAR;
        }
        if (type instanceof GraphQLObjectType) {
            return TypeKind.OBJECT;
        }
        if (type instanceof GraphQLInterfaceType) {
            return TypeKind.INTERFACE;
        }
        if (type instanceof GraphQLUnionType) {
            return TypeKind.UNION;
        }
        if (type instanceof GraphQLEnumType) {
            return TypeKind.ENUM;
        }
        if (type instanceof GraphQLInputObjectType) {
            return TypeKind.INPUT_OBJECT;
        }
        if (type instanceof GraphQLList) {
            return TypeKind.LIST;
        }
        if (type instanceof GraphQLNonNull) {
            return TypeKind.NON_NULL;
        }
        return Assert.assertShouldNeverHappen("Unknown kind of type: %s", type);
    };
    private static final IntrospectionDataFetcher<?> nameDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)type).getName();
        }
        return null;
    };
    private static final IntrospectionDataFetcher<?> descriptionDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)type).getDescription();
        }
        return null;
    };
    public static final GraphQLObjectType __InputValue = GraphQLObjectType.newObject().name("__InputValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("defaultValue").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
    public static final GraphQLObjectType __Field;
    public static final GraphQLObjectType __EnumValue;
    private static final IntrospectionDataFetcher<?> fieldsFetcher;
    private static final IntrospectionDataFetcher<?> interfacesFetcher;
    private static final IntrospectionDataFetcher<?> possibleTypesFetcher;
    private static final IntrospectionDataFetcher<?> enumValuesTypesFetcher;
    private static final IntrospectionDataFetcher<?> inputFieldsFetcher;
    private static final IntrospectionDataFetcher<?> OfTypeFetcher;
    private static final IntrospectionDataFetcher<?> specifiedByUrlDataFetcher;
    private static final IntrospectionDataFetcher<?> isOneOfFetcher;
    public static final GraphQLObjectType __Type;
    public static final GraphQLEnumType __DirectiveLocation;
    public static final GraphQLObjectType __Directive;
    public static final GraphQLObjectType __Schema;
    public static final GraphQLFieldDefinition SchemaMetaFieldDef;
    public static final GraphQLFieldDefinition TypeMetaFieldDef;
    public static final GraphQLFieldDefinition TypeNameMetaFieldDef;
    public static final Set<String> INTROSPECTION_SYSTEM_FIELDS;
    public static final IntrospectionDataFetcher<?> SchemaMetaFieldDefDataFetcher;
    public static final IntrospectionDataFetcher<?> TypeMetaFieldDefDataFetcher;
    public static final IntrospectionDataFetcher<?> TypeNameMetaFieldDefDataFetcher;
    private static final Set<String> introspectionTypes;

    public static boolean enabledJvmWide(boolean enabled) {
        return INTROSPECTION_ENABLED_STATE.getAndSet(enabled);
    }

    public static boolean isEnabledJvmWide() {
        return INTROSPECTION_ENABLED_STATE.get();
    }

    public static Optional<ExecutionResult> isIntrospectionSensible(MergedSelectionSet mergedSelectionSet, ExecutionContext executionContext) {
        GraphQLContext graphQLContext = executionContext.getGraphQLContext();
        boolean isIntrospection = false;
        for (String key : mergedSelectionSet.getKeys()) {
            String fieldName = mergedSelectionSet.getSubField(key).getName();
            if (!fieldName.equals(SchemaMetaFieldDef.getName()) && !fieldName.equals(TypeMetaFieldDef.getName())) continue;
            if (!Introspection.isIntrospectionEnabled(graphQLContext)) {
                return Introspection.mkDisabledError(mergedSelectionSet.getSubField(key));
            }
            isIntrospection = true;
            break;
        }
        if (isIntrospection) {
            return GoodFaithIntrospection.checkIntrospection(executionContext);
        }
        return Optional.empty();
    }

    private static @NonNull Optional<ExecutionResult> mkDisabledError(MergedField schemaField) {
        IntrospectionDisabledError error = new IntrospectionDisabledError(schemaField.getSingleField().getSourceLocation());
        return Optional.of(ExecutionResult.newExecutionResult().addError(error).build());
    }

    private static boolean isIntrospectionEnabled(GraphQLContext graphQlContext) {
        if (!Introspection.isEnabledJvmWide()) {
            return false;
        }
        return !graphQlContext.getBoolean(INTROSPECTION_DISABLED, false);
    }

    private static void register(GraphQLFieldsContainer parentType, String fieldName, IntrospectionDataFetcher<?> introspectionDataFetcher) {
        introspectionDataFetchers.put(FieldCoordinates.coordinates(parentType.getName(), fieldName), introspectionDataFetcher);
    }

    private static <T> void register(GraphQLFieldsContainer parentType, String fieldName, Class<T> targetClass, Function<T, Object> getter) {
        IntrospectionDataFetcher dataFetcher = env -> {
            Object source = env.getSource();
            if (targetClass.isInstance(source)) {
                return getter.apply(targetClass.cast(source));
            }
            return null;
        };
        introspectionDataFetchers.put(FieldCoordinates.coordinates(parentType.getName(), fieldName), dataFetcher);
    }

    @Internal
    public static void addCodeForIntrospectionTypes(GraphQLCodeRegistry.Builder codeRegistry) {
        codeRegistry.dataFetcherIfAbsent(FieldCoordinates.systemCoordinates(SchemaMetaFieldDef.getName()), SchemaMetaFieldDefDataFetcher);
        codeRegistry.dataFetcherIfAbsent(FieldCoordinates.systemCoordinates(TypeNameMetaFieldDef.getName()), TypeNameMetaFieldDefDataFetcher);
        codeRegistry.dataFetcherIfAbsent(FieldCoordinates.systemCoordinates(TypeMetaFieldDef.getName()), TypeMetaFieldDefDataFetcher);
        introspectionDataFetchers.forEach(codeRegistry::dataFetcherIfAbsent);
    }

    private static String printDefaultValue(InputValueWithState inputValueWithState, GraphQLInputType type, GraphQLContext graphQLContext, Locale locale) {
        return AstPrinter.printAst(ValuesResolver.valueToLiteral(inputValueWithState, type, graphQLContext, locale));
    }

    @Internal
    public static GraphQLFieldDefinition buildSchemaField(GraphQLObjectType introspectionSchemaType) {
        return GraphQLFieldDefinition.newFieldDefinition().name("__schema").type(GraphQLNonNull.nonNull(introspectionSchemaType)).description("Access the current type schema of this server.").build();
    }

    @Internal
    public static GraphQLFieldDefinition buildTypeField(GraphQLObjectType introspectionSchemaType) {
        GraphQLOutputType fieldType = introspectionSchemaType.getFieldDefinition("types").getType();
        GraphQLObjectType underscoreType = (GraphQLObjectType)GraphQLTypeUtil.unwrapAllAs(fieldType);
        return GraphQLFieldDefinition.newFieldDefinition().name("__type").type(underscoreType).description("Request the type information of a single type.").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).build();
    }

    public static boolean isIntrospectionTypes(GraphQLNamedType type) {
        return introspectionTypes.contains(type.getName());
    }

    public static boolean isIntrospectionTypes(String typeName) {
        return introspectionTypes.contains(typeName);
    }

    public static GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLCompositeType parentType, String fieldName) {
        GraphQLFieldDefinition fieldDefinition = Introspection.getSystemFieldDef(schema, parentType, fieldName);
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        Assert.assertTrue(parentType instanceof GraphQLFieldsContainer, "should not happen : parent type must be an object or interface %s", parentType);
        GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)parentType;
        fieldDefinition = schema.getCodeRegistry().getFieldVisibility().getFieldDefinition(fieldsContainer, fieldName);
        Assert.assertTrue(fieldDefinition != null, "Unknown field '%s' for type %s", fieldName, fieldsContainer.getName());
        return fieldDefinition;
    }

    public static GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, GraphQLFieldsContainer parentType, String fieldName) {
        GraphQLFieldDefinition fieldDefinition = schema.getCodeRegistry().getFieldVisibility().getFieldDefinition(parentType, fieldName);
        if (fieldDefinition == null && (fieldDefinition = Introspection.getSystemFieldDef(schema, parentType, fieldName)) == null) {
            Assert.assertShouldNeverHappen(String.format("Unknown field '%s' for type %s", fieldName, parentType.getName()), new Object[0]);
        }
        return fieldDefinition;
    }

    private static GraphQLFieldDefinition getSystemFieldDef(GraphQLSchema schema, GraphQLCompositeType parentType, String fieldName) {
        if (schema.getQueryType() == parentType) {
            if (fieldName.equals(schema.getIntrospectionSchemaFieldDefinition().getName())) {
                return schema.getIntrospectionSchemaFieldDefinition();
            }
            if (fieldName.equals(schema.getIntrospectionTypeFieldDefinition().getName())) {
                return schema.getIntrospectionTypeFieldDefinition();
            }
        }
        if (fieldName.equals(schema.getIntrospectionTypenameFieldDefinition().getName())) {
            return schema.getIntrospectionTypenameFieldDefinition();
        }
        return null;
    }

    static {
        IntrospectionDataFetcher defaultValueDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLArgument) {
                GraphQLArgument inputField = (GraphQLArgument)type;
                return inputField.hasSetDefaultValue() ? Introspection.printDefaultValue(inputField.getArgumentDefaultValue(), inputField.getType(), environment.getGraphQlContext(), environment.getLocale()) : null;
            }
            if (type instanceof GraphQLInputObjectField) {
                GraphQLInputObjectField inputField = (GraphQLInputObjectField)type;
                return inputField.hasSetDefaultValue() ? Introspection.printDefaultValue(inputField.getInputFieldDefaultValue(), inputField.getType(), environment.getGraphQlContext(), environment.getLocale()) : null;
            }
            return null;
        };
        IntrospectionDataFetcher isDeprecatedDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLArgument) {
                return ((GraphQLArgument)type).isDeprecated();
            }
            if (type instanceof GraphQLInputObjectField) {
                return ((GraphQLInputObjectField)type).isDeprecated();
            }
            return null;
        };
        IntrospectionDataFetcher typeDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLArgument) {
                return ((GraphQLArgument)type).getType();
            }
            if (type instanceof GraphQLInputObjectField) {
                return ((GraphQLInputObjectField)type).getType();
            }
            return null;
        };
        IntrospectionDataFetcher deprecationReasonDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLArgument) {
                return ((GraphQLArgument)type).getDeprecationReason();
            }
            if (type instanceof GraphQLInputObjectField) {
                return ((GraphQLInputObjectField)type).getDeprecationReason();
            }
            return null;
        };
        Introspection.register(__InputValue, "name", nameDataFetcher);
        Introspection.register(__InputValue, "description", descriptionDataFetcher);
        Introspection.register(__InputValue, "type", typeDataFetcher);
        Introspection.register(__InputValue, "defaultValue", defaultValueDataFetcher);
        Introspection.register(__InputValue, "isDeprecated", isDeprecatedDataFetcher);
        Introspection.register(__InputValue, "deprecationReason", deprecationReasonDataFetcher);
        __Field = GraphQLObjectType.newObject().name("__Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue)))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValueProgrammatic(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
        IntrospectionDataFetcher argsDataFetcher = environment -> {
            Object type = environment.getSource();
            GraphQLFieldDefinition fieldDef = (GraphQLFieldDefinition)type;
            Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            return fieldDef.getArguments().stream().filter(arg -> includeDeprecated != false || !arg.isDeprecated()).collect(Collectors.toList());
        };
        Introspection.register(__Field, "name", nameDataFetcher);
        Introspection.register(__Field, "description", descriptionDataFetcher);
        Introspection.register(__Field, "args", argsDataFetcher);
        Introspection.register(__Field, "type", GraphQLFieldDefinition.class, GraphQLFieldDefinition::getType);
        Introspection.register(__Field, "isDeprecated", GraphQLFieldDefinition.class, GraphQLFieldDefinition::isDeprecated);
        Introspection.register(__Field, "deprecationReason", GraphQLFieldDefinition.class, GraphQLFieldDefinition::getDeprecationReason);
        __EnumValue = GraphQLObjectType.newObject().name("__EnumValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
        Introspection.register(__EnumValue, "name", nameDataFetcher);
        Introspection.register(__EnumValue, "description", descriptionDataFetcher);
        Introspection.register(__EnumValue, "isDeprecated", GraphQLEnumValueDefinition.class, GraphQLEnumValueDefinition::isDeprecated);
        Introspection.register(__EnumValue, "deprecationReason", GraphQLEnumValueDefinition.class, GraphQLEnumValueDefinition::getDeprecationReason);
        fieldsFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLFieldsContainer) {
                GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)type;
                Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
                List<GraphQLFieldDefinition> fieldDefinitions = environment.getGraphQLSchema().getCodeRegistry().getFieldVisibility().getFieldDefinitions(fieldsContainer);
                if (includeDeprecated.booleanValue()) {
                    return fieldDefinitions;
                }
                return fieldDefinitions.stream().filter(field -> !field.isDeprecated()).collect(Collectors.toList());
            }
            return null;
        };
        interfacesFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLObjectType) {
                return ((GraphQLObjectType)type).getInterfaces();
            }
            if (type instanceof GraphQLInterfaceType) {
                return ((GraphQLInterfaceType)type).getInterfaces();
            }
            return null;
        };
        possibleTypesFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLInterfaceType) {
                return environment.getGraphQLSchema().getImplementations((GraphQLInterfaceType)type);
            }
            if (type instanceof GraphQLUnionType) {
                return ((GraphQLUnionType)type).getTypes();
            }
            return null;
        };
        enumValuesTypesFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLEnumType) {
                Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
                List<GraphQLEnumValueDefinition> values2 = ((GraphQLEnumType)type).getValues();
                if (includeDeprecated.booleanValue()) {
                    return values2;
                }
                return values2.stream().filter(enumValue -> !enumValue.isDeprecated()).collect(Collectors.toList());
            }
            return null;
        };
        inputFieldsFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLInputObjectType) {
                Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
                List<GraphQLInputObjectField> inputFields = environment.getGraphQLSchema().getCodeRegistry().getFieldVisibility().getFieldDefinitions((GraphQLInputObjectType)type);
                if (includeDeprecated.booleanValue()) {
                    return inputFields;
                }
                return inputFields.stream().filter(inputField -> !inputField.isDeprecated()).collect(Collectors.toList());
            }
            return null;
        };
        OfTypeFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLModifiedType) {
                return GraphQLTypeUtil.unwrapOne((GraphQLModifiedType)type);
            }
            return null;
        };
        specifiedByUrlDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLScalarType) {
                return ((GraphQLScalarType)type).getSpecifiedByUrl();
            }
            return null;
        };
        isOneOfFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLInputObjectType) {
                return ((GraphQLInputObjectType)type).isOneOf();
            }
            return null;
        };
        __Type = GraphQLObjectType.newObject().name("__Type").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type(GraphQLNonNull.nonNull(__TypeKind))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type(GraphQLList.list(GraphQLNonNull.nonNull(__Field))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValueProgrammatic(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("interfaces").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type"))))).field(GraphQLFieldDefinition.newFieldDefinition().name("possibleTypes").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type"))))).field(GraphQLFieldDefinition.newFieldDefinition().name("enumValues").type(GraphQLList.list(GraphQLNonNull.nonNull(__EnumValue))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValueProgrammatic(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("inputFields").type(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValueProgrammatic(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("ofType").type(GraphQLTypeReference.typeRef("__Type"))).field(GraphQLFieldDefinition.newFieldDefinition().name("isOneOf").description("This field is considered experimental because it has not yet been ratified in the graphql specification").type(Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("specifiedByURL").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("specifiedByUrl").type(Scalars.GraphQLString).deprecate("This legacy name has been replaced by `specifiedByURL`")).build();
        Introspection.register(__Type, "kind", kindDataFetcher);
        Introspection.register(__Type, "name", nameDataFetcher);
        Introspection.register(__Type, "description", descriptionDataFetcher);
        Introspection.register(__Type, "fields", fieldsFetcher);
        Introspection.register(__Type, "interfaces", interfacesFetcher);
        Introspection.register(__Type, "possibleTypes", possibleTypesFetcher);
        Introspection.register(__Type, "enumValues", enumValuesTypesFetcher);
        Introspection.register(__Type, "inputFields", inputFieldsFetcher);
        Introspection.register(__Type, "ofType", OfTypeFetcher);
        Introspection.register(__Type, "isOneOf", isOneOfFetcher);
        Introspection.register(__Type, "specifiedByURL", specifiedByUrlDataFetcher);
        Introspection.register(__Type, "specifiedByUrl", specifiedByUrlDataFetcher);
        __DirectiveLocation = GraphQLEnumType.newEnum().name("__DirectiveLocation").description("An enum describing valid locations where a directive can be placed").value("QUERY", (Object)DirectiveLocation.QUERY, "Indicates the directive is valid on queries.").value("MUTATION", (Object)DirectiveLocation.MUTATION, "Indicates the directive is valid on mutations.").value("SUBSCRIPTION", (Object)DirectiveLocation.SUBSCRIPTION, "Indicates the directive is valid on subscriptions.").value("FIELD", (Object)DirectiveLocation.FIELD, "Indicates the directive is valid on fields.").value("FRAGMENT_DEFINITION", (Object)DirectiveLocation.FRAGMENT_DEFINITION, "Indicates the directive is valid on fragment definitions.").value("FRAGMENT_SPREAD", (Object)DirectiveLocation.FRAGMENT_SPREAD, "Indicates the directive is valid on fragment spreads.").value("INLINE_FRAGMENT", (Object)DirectiveLocation.INLINE_FRAGMENT, "Indicates the directive is valid on inline fragments.").value("VARIABLE_DEFINITION", (Object)DirectiveLocation.VARIABLE_DEFINITION, "Indicates the directive is valid on variable definitions.").value("SCHEMA", (Object)DirectiveLocation.SCHEMA, "Indicates the directive is valid on a schema SDL definition.").value("SCALAR", (Object)DirectiveLocation.SCALAR, "Indicates the directive is valid on a scalar SDL definition.").value("OBJECT", (Object)DirectiveLocation.OBJECT, "Indicates the directive is valid on an object SDL definition.").value("FIELD_DEFINITION", (Object)DirectiveLocation.FIELD_DEFINITION, "Indicates the directive is valid on a field SDL definition.").value("ARGUMENT_DEFINITION", (Object)DirectiveLocation.ARGUMENT_DEFINITION, "Indicates the directive is valid on a field argument SDL definition.").value("INTERFACE", (Object)DirectiveLocation.INTERFACE, "Indicates the directive is valid on an interface SDL definition.").value("UNION", (Object)DirectiveLocation.UNION, "Indicates the directive is valid on an union SDL definition.").value("ENUM", (Object)DirectiveLocation.ENUM, "Indicates the directive is valid on an enum SDL definition.").value("ENUM_VALUE", (Object)DirectiveLocation.ENUM_VALUE, "Indicates the directive is valid on an enum value SDL definition.").value("INPUT_OBJECT", (Object)DirectiveLocation.INPUT_OBJECT, "Indicates the directive is valid on an input object SDL definition.").value("INPUT_FIELD_DEFINITION", (Object)DirectiveLocation.INPUT_FIELD_DEFINITION, "Indicates the directive is valid on an input object field SDL definition.").build();
        __Directive = GraphQLObjectType.newObject().name("__Directive").field(GraphQLFieldDefinition.newFieldDefinition().name("name").description("The __Directive type represents a Directive that a server supports.").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isRepeatable").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("locations").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__DirectiveLocation))))).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue)))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValueProgrammatic(false))).build();
        IntrospectionDataFetcher locationsDataFetcher = environment -> {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            return new ArrayList<DirectiveLocation>(directive.validLocations());
        };
        IntrospectionDataFetcher argsDataFetcher2 = environment -> {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            return directive.getArguments().stream().filter(arg -> includeDeprecated != false || !arg.isDeprecated()).collect(Collectors.toList());
        };
        Introspection.register(__Directive, "name", nameDataFetcher);
        Introspection.register(__Directive, "description", descriptionDataFetcher);
        Introspection.register(__Directive, "isRepeatable", GraphQLDirective.class, GraphQLDirective::isRepeatable);
        Introspection.register(__Directive, "locations", locationsDataFetcher);
        Introspection.register(__Directive, "args", argsDataFetcher2);
        __Schema = GraphQLObjectType.newObject().name("__Schema").description("A GraphQL Introspection defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, the entry points for query, mutation, and subscription operations.").field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("types").description("A list of all types supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Type))))).field(GraphQLFieldDefinition.newFieldDefinition().name("queryType").description("The type that query operations will be rooted at.").type(GraphQLNonNull.nonNull(__Type))).field(GraphQLFieldDefinition.newFieldDefinition().name("mutationType").description("If this server supports mutation, the type that mutation operations will be rooted at.").type(__Type)).field(GraphQLFieldDefinition.newFieldDefinition().name("directives").description("'A list of all directives supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Directive))))).field(GraphQLFieldDefinition.newFieldDefinition().name("subscriptionType").description("'If this server support subscription, the type that subscription operations will be rooted at.").type(__Type)).build();
        IntrospectionDataFetcher descriptionsDataFetcher = environment -> environment.getGraphQLSchema().getDescription();
        Introspection.register(__Schema, "description", descriptionsDataFetcher);
        Introspection.register(__Schema, "types", GraphQLSchema.class, GraphQLSchema::getAllTypesAsList);
        Introspection.register(__Schema, "queryType", GraphQLSchema.class, GraphQLSchema::getQueryType);
        Introspection.register(__Schema, "mutationType", GraphQLSchema.class, GraphQLSchema::getMutationType);
        Introspection.register(__Schema, "directives", GraphQLSchema.class, GraphQLSchema::getDirectives);
        Introspection.register(__Schema, "subscriptionType", GraphQLSchema.class, GraphQLSchema::getSubscriptionType);
        SchemaMetaFieldDef = Introspection.buildSchemaField(__Schema);
        TypeMetaFieldDef = Introspection.buildTypeField(__Schema);
        TypeNameMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__typename").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("The name of the current Object type at runtime.").build();
        INTROSPECTION_SYSTEM_FIELDS = ImmutableSet.of(SchemaMetaFieldDef.getName(), TypeMetaFieldDef.getName(), TypeNameMetaFieldDef.getName());
        SchemaMetaFieldDefDataFetcher = IntrospectionDataFetchingEnvironment::getGraphQLSchema;
        TypeMetaFieldDefDataFetcher = environment -> {
            String name = (String)environment.getArgument("name");
            return environment.getGraphQLSchema().getType(name);
        };
        TypeNameMetaFieldDefDataFetcher = environment -> GraphQLTypeUtil.simplePrint(environment.getParentType());
        introspectionTypes = new HashSet<String>();
        GraphQLObjectType IntrospectionQuery2 = GraphQLObjectType.newObject().name("IntrospectionQuery").field(SchemaMetaFieldDef).field(TypeMetaFieldDef).field(TypeNameMetaFieldDef).build();
        introspectionTypes.add(__DirectiveLocation.getName());
        introspectionTypes.add(__TypeKind.getName());
        introspectionTypes.add(__Type.getName());
        introspectionTypes.add(__Schema.getName());
        introspectionTypes.add(__InputValue.getName());
        introspectionTypes.add(__Field.getName());
        introspectionTypes.add(__EnumValue.getName());
        introspectionTypes.add(__Directive.getName());
        GraphQLSchema.newSchema().query(IntrospectionQuery2).build();
    }

    public static enum DirectiveLocation {
        QUERY,
        MUTATION,
        SUBSCRIPTION,
        FIELD,
        FRAGMENT_DEFINITION,
        FRAGMENT_SPREAD,
        INLINE_FRAGMENT,
        VARIABLE_DEFINITION,
        SCHEMA,
        SCALAR,
        OBJECT,
        FIELD_DEFINITION,
        ARGUMENT_DEFINITION,
        INTERFACE,
        UNION,
        ENUM,
        ENUM_VALUE,
        INPUT_OBJECT,
        INPUT_FIELD_DEFINITION;

    }

    public static enum TypeKind {
        SCALAR,
        OBJECT,
        INTERFACE,
        UNION,
        ENUM,
        INPUT_OBJECT,
        LIST,
        NON_NULL;

    }
}

